// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplify

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.amplify.auth.AmplifyAuthSchemeProvider
import aws.sdk.kotlin.services.amplify.auth.DefaultAmplifyAuthSchemeProvider
import aws.sdk.kotlin.services.amplify.endpoints.AmplifyEndpointParameters
import aws.sdk.kotlin.services.amplify.endpoints.AmplifyEndpointProvider
import aws.sdk.kotlin.services.amplify.endpoints.DefaultAmplifyEndpointProvider
import aws.sdk.kotlin.services.amplify.model.CreateAppRequest
import aws.sdk.kotlin.services.amplify.model.CreateAppResponse
import aws.sdk.kotlin.services.amplify.model.CreateBackendEnvironmentRequest
import aws.sdk.kotlin.services.amplify.model.CreateBackendEnvironmentResponse
import aws.sdk.kotlin.services.amplify.model.CreateBranchRequest
import aws.sdk.kotlin.services.amplify.model.CreateBranchResponse
import aws.sdk.kotlin.services.amplify.model.CreateDeploymentRequest
import aws.sdk.kotlin.services.amplify.model.CreateDeploymentResponse
import aws.sdk.kotlin.services.amplify.model.CreateDomainAssociationRequest
import aws.sdk.kotlin.services.amplify.model.CreateDomainAssociationResponse
import aws.sdk.kotlin.services.amplify.model.CreateWebhookRequest
import aws.sdk.kotlin.services.amplify.model.CreateWebhookResponse
import aws.sdk.kotlin.services.amplify.model.DeleteAppRequest
import aws.sdk.kotlin.services.amplify.model.DeleteAppResponse
import aws.sdk.kotlin.services.amplify.model.DeleteBackendEnvironmentRequest
import aws.sdk.kotlin.services.amplify.model.DeleteBackendEnvironmentResponse
import aws.sdk.kotlin.services.amplify.model.DeleteBranchRequest
import aws.sdk.kotlin.services.amplify.model.DeleteBranchResponse
import aws.sdk.kotlin.services.amplify.model.DeleteDomainAssociationRequest
import aws.sdk.kotlin.services.amplify.model.DeleteDomainAssociationResponse
import aws.sdk.kotlin.services.amplify.model.DeleteJobRequest
import aws.sdk.kotlin.services.amplify.model.DeleteJobResponse
import aws.sdk.kotlin.services.amplify.model.DeleteWebhookRequest
import aws.sdk.kotlin.services.amplify.model.DeleteWebhookResponse
import aws.sdk.kotlin.services.amplify.model.GenerateAccessLogsRequest
import aws.sdk.kotlin.services.amplify.model.GenerateAccessLogsResponse
import aws.sdk.kotlin.services.amplify.model.GetAppRequest
import aws.sdk.kotlin.services.amplify.model.GetAppResponse
import aws.sdk.kotlin.services.amplify.model.GetArtifactUrlRequest
import aws.sdk.kotlin.services.amplify.model.GetArtifactUrlResponse
import aws.sdk.kotlin.services.amplify.model.GetBackendEnvironmentRequest
import aws.sdk.kotlin.services.amplify.model.GetBackendEnvironmentResponse
import aws.sdk.kotlin.services.amplify.model.GetBranchRequest
import aws.sdk.kotlin.services.amplify.model.GetBranchResponse
import aws.sdk.kotlin.services.amplify.model.GetDomainAssociationRequest
import aws.sdk.kotlin.services.amplify.model.GetDomainAssociationResponse
import aws.sdk.kotlin.services.amplify.model.GetJobRequest
import aws.sdk.kotlin.services.amplify.model.GetJobResponse
import aws.sdk.kotlin.services.amplify.model.GetWebhookRequest
import aws.sdk.kotlin.services.amplify.model.GetWebhookResponse
import aws.sdk.kotlin.services.amplify.model.ListAppsRequest
import aws.sdk.kotlin.services.amplify.model.ListAppsResponse
import aws.sdk.kotlin.services.amplify.model.ListArtifactsRequest
import aws.sdk.kotlin.services.amplify.model.ListArtifactsResponse
import aws.sdk.kotlin.services.amplify.model.ListBackendEnvironmentsRequest
import aws.sdk.kotlin.services.amplify.model.ListBackendEnvironmentsResponse
import aws.sdk.kotlin.services.amplify.model.ListBranchesRequest
import aws.sdk.kotlin.services.amplify.model.ListBranchesResponse
import aws.sdk.kotlin.services.amplify.model.ListDomainAssociationsRequest
import aws.sdk.kotlin.services.amplify.model.ListDomainAssociationsResponse
import aws.sdk.kotlin.services.amplify.model.ListJobsRequest
import aws.sdk.kotlin.services.amplify.model.ListJobsResponse
import aws.sdk.kotlin.services.amplify.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.amplify.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.amplify.model.ListWebhooksRequest
import aws.sdk.kotlin.services.amplify.model.ListWebhooksResponse
import aws.sdk.kotlin.services.amplify.model.StartDeploymentRequest
import aws.sdk.kotlin.services.amplify.model.StartDeploymentResponse
import aws.sdk.kotlin.services.amplify.model.StartJobRequest
import aws.sdk.kotlin.services.amplify.model.StartJobResponse
import aws.sdk.kotlin.services.amplify.model.StopJobRequest
import aws.sdk.kotlin.services.amplify.model.StopJobResponse
import aws.sdk.kotlin.services.amplify.model.TagResourceRequest
import aws.sdk.kotlin.services.amplify.model.TagResourceResponse
import aws.sdk.kotlin.services.amplify.model.UntagResourceRequest
import aws.sdk.kotlin.services.amplify.model.UntagResourceResponse
import aws.sdk.kotlin.services.amplify.model.UpdateAppRequest
import aws.sdk.kotlin.services.amplify.model.UpdateAppResponse
import aws.sdk.kotlin.services.amplify.model.UpdateBranchRequest
import aws.sdk.kotlin.services.amplify.model.UpdateBranchResponse
import aws.sdk.kotlin.services.amplify.model.UpdateDomainAssociationRequest
import aws.sdk.kotlin.services.amplify.model.UpdateDomainAssociationResponse
import aws.sdk.kotlin.services.amplify.model.UpdateWebhookRequest
import aws.sdk.kotlin.services.amplify.model.UpdateWebhookResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Amplify"
public const val SdkVersion: String = "1.4.72"
public const val ServiceApiVersion: String = "2017-07-25"

/**
 * Amplify enables developers to develop and deploy cloud-powered mobile and web apps. Amplify Hosting provides a continuous delivery and hosting service for web applications. For more information, see the [Amplify Hosting User Guide](https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html). The Amplify Framework is a comprehensive set of SDKs, libraries, tools, and documentation for client app development. For more information, see the [Amplify Framework.](https://docs.amplify.aws/)
 */
public interface AmplifyClient : SdkClient {
    /**
     * AmplifyClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, AmplifyClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Amplify",
                "AMPLIFY",
                "amplify",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, AmplifyClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): AmplifyClient = DefaultAmplifyClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: AmplifyEndpointProvider = builder.endpointProvider ?: DefaultAmplifyEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: AmplifyAuthSchemeProvider = builder.authSchemeProvider ?: DefaultAmplifyAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Amplify"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: AmplifyEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: AmplifyAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a new Amplify app.
     */
    public suspend fun createApp(input: CreateAppRequest): CreateAppResponse

    /**
     * Creates a new backend environment for an Amplify app.
     *
     * This API is available only to Amplify Gen 1 applications where the backend is created using Amplify Studio or the Amplify command line interface (CLI). This API isn’t available to Amplify Gen 2 applications. When you deploy an application with Amplify Gen 2, you provision the app's backend infrastructure using Typescript code.
     */
    public suspend fun createBackendEnvironment(input: CreateBackendEnvironmentRequest): CreateBackendEnvironmentResponse

    /**
     * Creates a new branch for an Amplify app.
     */
    public suspend fun createBranch(input: CreateBranchRequest): CreateBranchResponse

    /**
     * Creates a deployment for a manually deployed Amplify app. Manually deployed apps are not connected to a Git repository.
     *
     * The maximum duration between the `CreateDeployment` call and the `StartDeployment` call cannot exceed 8 hours. If the duration exceeds 8 hours, the `StartDeployment` call and the associated `Job` will fail.
     */
    public suspend fun createDeployment(input: CreateDeploymentRequest): CreateDeploymentResponse

    /**
     * Creates a new domain association for an Amplify app. This action associates a custom domain with the Amplify app
     */
    public suspend fun createDomainAssociation(input: CreateDomainAssociationRequest): CreateDomainAssociationResponse

    /**
     * Creates a new webhook on an Amplify app.
     */
    public suspend fun createWebhook(input: CreateWebhookRequest): CreateWebhookResponse

    /**
     * Deletes an existing Amplify app specified by an app ID.
     */
    public suspend fun deleteApp(input: DeleteAppRequest): DeleteAppResponse

    /**
     * Deletes a backend environment for an Amplify app.
     *
     * This API is available only to Amplify Gen 1 applications where the backend is created using Amplify Studio or the Amplify command line interface (CLI). This API isn’t available to Amplify Gen 2 applications. When you deploy an application with Amplify Gen 2, you provision the app's backend infrastructure using Typescript code.
     */
    public suspend fun deleteBackendEnvironment(input: DeleteBackendEnvironmentRequest): DeleteBackendEnvironmentResponse

    /**
     * Deletes a branch for an Amplify app.
     */
    public suspend fun deleteBranch(input: DeleteBranchRequest): DeleteBranchResponse

    /**
     * Deletes a domain association for an Amplify app.
     */
    public suspend fun deleteDomainAssociation(input: DeleteDomainAssociationRequest): DeleteDomainAssociationResponse

    /**
     * Deletes a job for a branch of an Amplify app.
     */
    public suspend fun deleteJob(input: DeleteJobRequest): DeleteJobResponse

    /**
     * Deletes a webhook.
     */
    public suspend fun deleteWebhook(input: DeleteWebhookRequest): DeleteWebhookResponse

    /**
     * Returns the website access logs for a specific time range using a presigned URL.
     */
    public suspend fun generateAccessLogs(input: GenerateAccessLogsRequest): GenerateAccessLogsResponse

    /**
     * Returns an existing Amplify app specified by an app ID.
     */
    public suspend fun getApp(input: GetAppRequest): GetAppResponse

    /**
     * Returns the artifact info that corresponds to an artifact id.
     */
    public suspend fun getArtifactUrl(input: GetArtifactUrlRequest): GetArtifactUrlResponse

    /**
     * Returns a backend environment for an Amplify app.
     *
     * This API is available only to Amplify Gen 1 applications where the backend is created using Amplify Studio or the Amplify command line interface (CLI). This API isn’t available to Amplify Gen 2 applications. When you deploy an application with Amplify Gen 2, you provision the app's backend infrastructure using Typescript code.
     */
    public suspend fun getBackendEnvironment(input: GetBackendEnvironmentRequest): GetBackendEnvironmentResponse

    /**
     * Returns a branch for an Amplify app.
     */
    public suspend fun getBranch(input: GetBranchRequest): GetBranchResponse

    /**
     * Returns the domain information for an Amplify app.
     */
    public suspend fun getDomainAssociation(input: GetDomainAssociationRequest): GetDomainAssociationResponse

    /**
     * Returns a job for a branch of an Amplify app.
     */
    public suspend fun getJob(input: GetJobRequest): GetJobResponse

    /**
     * Returns the webhook information that corresponds to a specified webhook ID.
     */
    public suspend fun getWebhook(input: GetWebhookRequest): GetWebhookResponse

    /**
     * Returns a list of the existing Amplify apps.
     */
    public suspend fun listApps(input: ListAppsRequest = ListAppsRequest { }): ListAppsResponse

    /**
     * Returns a list of end-to-end testing artifacts for a specified app, branch, and job.
     *
     * To return the build artifacts, use the [GetJob](https://docs.aws.amazon.com/amplify/latest/APIReference/API_GetJob.html) API.
     *
     * For more information about Amplify testing support, see [Setting up end-to-end Cypress tests for your Amplify application](https://docs.aws.amazon.com/amplify/latest/userguide/running-tests.html) in the *Amplify Hosting User Guide*.
     */
    public suspend fun listArtifacts(input: ListArtifactsRequest): ListArtifactsResponse

    /**
     * Lists the backend environments for an Amplify app.
     *
     * This API is available only to Amplify Gen 1 applications where the backend is created using Amplify Studio or the Amplify command line interface (CLI). This API isn’t available to Amplify Gen 2 applications. When you deploy an application with Amplify Gen 2, you provision the app's backend infrastructure using Typescript code.
     */
    public suspend fun listBackendEnvironments(input: ListBackendEnvironmentsRequest): ListBackendEnvironmentsResponse

    /**
     * Lists the branches of an Amplify app.
     */
    public suspend fun listBranches(input: ListBranchesRequest): ListBranchesResponse

    /**
     * Returns the domain associations for an Amplify app.
     */
    public suspend fun listDomainAssociations(input: ListDomainAssociationsRequest): ListDomainAssociationsResponse

    /**
     * Lists the jobs for a branch of an Amplify app.
     */
    public suspend fun listJobs(input: ListJobsRequest): ListJobsResponse

    /**
     * Returns a list of tags for a specified Amazon Resource Name (ARN).
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Returns a list of webhooks for an Amplify app.
     */
    public suspend fun listWebhooks(input: ListWebhooksRequest): ListWebhooksResponse

    /**
     * Starts a deployment for a manually deployed app. Manually deployed apps are not connected to a Git repository.
     *
     * The maximum duration between the `CreateDeployment` call and the `StartDeployment` call cannot exceed 8 hours. If the duration exceeds 8 hours, the `StartDeployment` call and the associated `Job` will fail.
     */
    public suspend fun startDeployment(input: StartDeploymentRequest): StartDeploymentResponse

    /**
     * Starts a new job for a branch of an Amplify app.
     */
    public suspend fun startJob(input: StartJobRequest): StartJobResponse

    /**
     * Stops a job that is in progress for a branch of an Amplify app.
     */
    public suspend fun stopJob(input: StopJobRequest): StopJobResponse

    /**
     * Tags the resource with a tag key and value.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Untags a resource with a specified Amazon Resource Name (ARN).
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an existing Amplify app.
     */
    public suspend fun updateApp(input: UpdateAppRequest): UpdateAppResponse

    /**
     * Updates a branch for an Amplify app.
     */
    public suspend fun updateBranch(input: UpdateBranchRequest): UpdateBranchResponse

    /**
     * Creates a new domain association for an Amplify app.
     */
    public suspend fun updateDomainAssociation(input: UpdateDomainAssociationRequest): UpdateDomainAssociationResponse

    /**
     * Updates a webhook.
     */
    public suspend fun updateWebhook(input: UpdateWebhookRequest): UpdateWebhookResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun AmplifyClient.withConfig(block: AmplifyClient.Config.Builder.() -> Unit): AmplifyClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultAmplifyClient(newConfig)
}

/**
 * Creates a new Amplify app.
 */
public suspend inline fun AmplifyClient.createApp(crossinline block: CreateAppRequest.Builder.() -> Unit): CreateAppResponse = createApp(CreateAppRequest.Builder().apply(block).build())

/**
 * Creates a new backend environment for an Amplify app.
 *
 * This API is available only to Amplify Gen 1 applications where the backend is created using Amplify Studio or the Amplify command line interface (CLI). This API isn’t available to Amplify Gen 2 applications. When you deploy an application with Amplify Gen 2, you provision the app's backend infrastructure using Typescript code.
 */
public suspend inline fun AmplifyClient.createBackendEnvironment(crossinline block: CreateBackendEnvironmentRequest.Builder.() -> Unit): CreateBackendEnvironmentResponse = createBackendEnvironment(CreateBackendEnvironmentRequest.Builder().apply(block).build())

/**
 * Creates a new branch for an Amplify app.
 */
public suspend inline fun AmplifyClient.createBranch(crossinline block: CreateBranchRequest.Builder.() -> Unit): CreateBranchResponse = createBranch(CreateBranchRequest.Builder().apply(block).build())

/**
 * Creates a deployment for a manually deployed Amplify app. Manually deployed apps are not connected to a Git repository.
 *
 * The maximum duration between the `CreateDeployment` call and the `StartDeployment` call cannot exceed 8 hours. If the duration exceeds 8 hours, the `StartDeployment` call and the associated `Job` will fail.
 */
public suspend inline fun AmplifyClient.createDeployment(crossinline block: CreateDeploymentRequest.Builder.() -> Unit): CreateDeploymentResponse = createDeployment(CreateDeploymentRequest.Builder().apply(block).build())

/**
 * Creates a new domain association for an Amplify app. This action associates a custom domain with the Amplify app
 */
public suspend inline fun AmplifyClient.createDomainAssociation(crossinline block: CreateDomainAssociationRequest.Builder.() -> Unit): CreateDomainAssociationResponse = createDomainAssociation(CreateDomainAssociationRequest.Builder().apply(block).build())

/**
 * Creates a new webhook on an Amplify app.
 */
public suspend inline fun AmplifyClient.createWebhook(crossinline block: CreateWebhookRequest.Builder.() -> Unit): CreateWebhookResponse = createWebhook(CreateWebhookRequest.Builder().apply(block).build())

/**
 * Deletes an existing Amplify app specified by an app ID.
 */
public suspend inline fun AmplifyClient.deleteApp(crossinline block: DeleteAppRequest.Builder.() -> Unit): DeleteAppResponse = deleteApp(DeleteAppRequest.Builder().apply(block).build())

/**
 * Deletes a backend environment for an Amplify app.
 *
 * This API is available only to Amplify Gen 1 applications where the backend is created using Amplify Studio or the Amplify command line interface (CLI). This API isn’t available to Amplify Gen 2 applications. When you deploy an application with Amplify Gen 2, you provision the app's backend infrastructure using Typescript code.
 */
public suspend inline fun AmplifyClient.deleteBackendEnvironment(crossinline block: DeleteBackendEnvironmentRequest.Builder.() -> Unit): DeleteBackendEnvironmentResponse = deleteBackendEnvironment(DeleteBackendEnvironmentRequest.Builder().apply(block).build())

/**
 * Deletes a branch for an Amplify app.
 */
public suspend inline fun AmplifyClient.deleteBranch(crossinline block: DeleteBranchRequest.Builder.() -> Unit): DeleteBranchResponse = deleteBranch(DeleteBranchRequest.Builder().apply(block).build())

/**
 * Deletes a domain association for an Amplify app.
 */
public suspend inline fun AmplifyClient.deleteDomainAssociation(crossinline block: DeleteDomainAssociationRequest.Builder.() -> Unit): DeleteDomainAssociationResponse = deleteDomainAssociation(DeleteDomainAssociationRequest.Builder().apply(block).build())

/**
 * Deletes a job for a branch of an Amplify app.
 */
public suspend inline fun AmplifyClient.deleteJob(crossinline block: DeleteJobRequest.Builder.() -> Unit): DeleteJobResponse = deleteJob(DeleteJobRequest.Builder().apply(block).build())

/**
 * Deletes a webhook.
 */
public suspend inline fun AmplifyClient.deleteWebhook(crossinline block: DeleteWebhookRequest.Builder.() -> Unit): DeleteWebhookResponse = deleteWebhook(DeleteWebhookRequest.Builder().apply(block).build())

/**
 * Returns the website access logs for a specific time range using a presigned URL.
 */
public suspend inline fun AmplifyClient.generateAccessLogs(crossinline block: GenerateAccessLogsRequest.Builder.() -> Unit): GenerateAccessLogsResponse = generateAccessLogs(GenerateAccessLogsRequest.Builder().apply(block).build())

/**
 * Returns an existing Amplify app specified by an app ID.
 */
public suspend inline fun AmplifyClient.getApp(crossinline block: GetAppRequest.Builder.() -> Unit): GetAppResponse = getApp(GetAppRequest.Builder().apply(block).build())

/**
 * Returns the artifact info that corresponds to an artifact id.
 */
public suspend inline fun AmplifyClient.getArtifactUrl(crossinline block: GetArtifactUrlRequest.Builder.() -> Unit): GetArtifactUrlResponse = getArtifactUrl(GetArtifactUrlRequest.Builder().apply(block).build())

/**
 * Returns a backend environment for an Amplify app.
 *
 * This API is available only to Amplify Gen 1 applications where the backend is created using Amplify Studio or the Amplify command line interface (CLI). This API isn’t available to Amplify Gen 2 applications. When you deploy an application with Amplify Gen 2, you provision the app's backend infrastructure using Typescript code.
 */
public suspend inline fun AmplifyClient.getBackendEnvironment(crossinline block: GetBackendEnvironmentRequest.Builder.() -> Unit): GetBackendEnvironmentResponse = getBackendEnvironment(GetBackendEnvironmentRequest.Builder().apply(block).build())

/**
 * Returns a branch for an Amplify app.
 */
public suspend inline fun AmplifyClient.getBranch(crossinline block: GetBranchRequest.Builder.() -> Unit): GetBranchResponse = getBranch(GetBranchRequest.Builder().apply(block).build())

/**
 * Returns the domain information for an Amplify app.
 */
public suspend inline fun AmplifyClient.getDomainAssociation(crossinline block: GetDomainAssociationRequest.Builder.() -> Unit): GetDomainAssociationResponse = getDomainAssociation(GetDomainAssociationRequest.Builder().apply(block).build())

/**
 * Returns a job for a branch of an Amplify app.
 */
public suspend inline fun AmplifyClient.getJob(crossinline block: GetJobRequest.Builder.() -> Unit): GetJobResponse = getJob(GetJobRequest.Builder().apply(block).build())

/**
 * Returns the webhook information that corresponds to a specified webhook ID.
 */
public suspend inline fun AmplifyClient.getWebhook(crossinline block: GetWebhookRequest.Builder.() -> Unit): GetWebhookResponse = getWebhook(GetWebhookRequest.Builder().apply(block).build())

/**
 * Returns a list of the existing Amplify apps.
 */
public suspend inline fun AmplifyClient.listApps(crossinline block: ListAppsRequest.Builder.() -> Unit): ListAppsResponse = listApps(ListAppsRequest.Builder().apply(block).build())

/**
 * Returns a list of end-to-end testing artifacts for a specified app, branch, and job.
 *
 * To return the build artifacts, use the [GetJob](https://docs.aws.amazon.com/amplify/latest/APIReference/API_GetJob.html) API.
 *
 * For more information about Amplify testing support, see [Setting up end-to-end Cypress tests for your Amplify application](https://docs.aws.amazon.com/amplify/latest/userguide/running-tests.html) in the *Amplify Hosting User Guide*.
 */
public suspend inline fun AmplifyClient.listArtifacts(crossinline block: ListArtifactsRequest.Builder.() -> Unit): ListArtifactsResponse = listArtifacts(ListArtifactsRequest.Builder().apply(block).build())

/**
 * Lists the backend environments for an Amplify app.
 *
 * This API is available only to Amplify Gen 1 applications where the backend is created using Amplify Studio or the Amplify command line interface (CLI). This API isn’t available to Amplify Gen 2 applications. When you deploy an application with Amplify Gen 2, you provision the app's backend infrastructure using Typescript code.
 */
public suspend inline fun AmplifyClient.listBackendEnvironments(crossinline block: ListBackendEnvironmentsRequest.Builder.() -> Unit): ListBackendEnvironmentsResponse = listBackendEnvironments(ListBackendEnvironmentsRequest.Builder().apply(block).build())

/**
 * Lists the branches of an Amplify app.
 */
public suspend inline fun AmplifyClient.listBranches(crossinline block: ListBranchesRequest.Builder.() -> Unit): ListBranchesResponse = listBranches(ListBranchesRequest.Builder().apply(block).build())

/**
 * Returns the domain associations for an Amplify app.
 */
public suspend inline fun AmplifyClient.listDomainAssociations(crossinline block: ListDomainAssociationsRequest.Builder.() -> Unit): ListDomainAssociationsResponse = listDomainAssociations(ListDomainAssociationsRequest.Builder().apply(block).build())

/**
 * Lists the jobs for a branch of an Amplify app.
 */
public suspend inline fun AmplifyClient.listJobs(crossinline block: ListJobsRequest.Builder.() -> Unit): ListJobsResponse = listJobs(ListJobsRequest.Builder().apply(block).build())

/**
 * Returns a list of tags for a specified Amazon Resource Name (ARN).
 */
public suspend inline fun AmplifyClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Returns a list of webhooks for an Amplify app.
 */
public suspend inline fun AmplifyClient.listWebhooks(crossinline block: ListWebhooksRequest.Builder.() -> Unit): ListWebhooksResponse = listWebhooks(ListWebhooksRequest.Builder().apply(block).build())

/**
 * Starts a deployment for a manually deployed app. Manually deployed apps are not connected to a Git repository.
 *
 * The maximum duration between the `CreateDeployment` call and the `StartDeployment` call cannot exceed 8 hours. If the duration exceeds 8 hours, the `StartDeployment` call and the associated `Job` will fail.
 */
public suspend inline fun AmplifyClient.startDeployment(crossinline block: StartDeploymentRequest.Builder.() -> Unit): StartDeploymentResponse = startDeployment(StartDeploymentRequest.Builder().apply(block).build())

/**
 * Starts a new job for a branch of an Amplify app.
 */
public suspend inline fun AmplifyClient.startJob(crossinline block: StartJobRequest.Builder.() -> Unit): StartJobResponse = startJob(StartJobRequest.Builder().apply(block).build())

/**
 * Stops a job that is in progress for a branch of an Amplify app.
 */
public suspend inline fun AmplifyClient.stopJob(crossinline block: StopJobRequest.Builder.() -> Unit): StopJobResponse = stopJob(StopJobRequest.Builder().apply(block).build())

/**
 * Tags the resource with a tag key and value.
 */
public suspend inline fun AmplifyClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Untags a resource with a specified Amazon Resource Name (ARN).
 */
public suspend inline fun AmplifyClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an existing Amplify app.
 */
public suspend inline fun AmplifyClient.updateApp(crossinline block: UpdateAppRequest.Builder.() -> Unit): UpdateAppResponse = updateApp(UpdateAppRequest.Builder().apply(block).build())

/**
 * Updates a branch for an Amplify app.
 */
public suspend inline fun AmplifyClient.updateBranch(crossinline block: UpdateBranchRequest.Builder.() -> Unit): UpdateBranchResponse = updateBranch(UpdateBranchRequest.Builder().apply(block).build())

/**
 * Creates a new domain association for an Amplify app.
 */
public suspend inline fun AmplifyClient.updateDomainAssociation(crossinline block: UpdateDomainAssociationRequest.Builder.() -> Unit): UpdateDomainAssociationResponse = updateDomainAssociation(UpdateDomainAssociationRequest.Builder().apply(block).build())

/**
 * Updates a webhook.
 */
public suspend inline fun AmplifyClient.updateWebhook(crossinline block: UpdateWebhookRequest.Builder.() -> Unit): UpdateWebhookResponse = updateWebhook(UpdateWebhookRequest.Builder().apply(block).build())
