// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplify.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a webhook that connects repository events to an Amplify app.
 */
public class Webhook private constructor(builder: Builder) {
    /**
     * The name for a branch that is part of an Amplify app.
     */
    public val branchName: kotlin.String = requireNotNull(builder.branchName) { "A non-null value must be provided for branchName" }
    /**
     * The create date and time for a webhook.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createTime) { "A non-null value must be provided for createTime" }
    /**
     * The description for a webhook.
     */
    public val description: kotlin.String = requireNotNull(builder.description) { "A non-null value must be provided for description" }
    /**
     * Updates the date and time for a webhook.
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updateTime) { "A non-null value must be provided for updateTime" }
    /**
     * The Amazon Resource Name (ARN) for the webhook.
     */
    public val webhookArn: kotlin.String = requireNotNull(builder.webhookArn) { "A non-null value must be provided for webhookArn" }
    /**
     * The ID of the webhook.
     */
    public val webhookId: kotlin.String = requireNotNull(builder.webhookId) { "A non-null value must be provided for webhookId" }
    /**
     * The URL of the webhook.
     */
    public val webhookUrl: kotlin.String = requireNotNull(builder.webhookUrl) { "A non-null value must be provided for webhookUrl" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amplify.model.Webhook = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Webhook(")
        append("branchName=$branchName,")
        append("createTime=$createTime,")
        append("description=$description,")
        append("updateTime=$updateTime,")
        append("webhookArn=$webhookArn,")
        append("webhookId=$webhookId,")
        append("webhookUrl=$webhookUrl")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = branchName.hashCode()
        result = 31 * result + (createTime.hashCode())
        result = 31 * result + (description.hashCode())
        result = 31 * result + (updateTime.hashCode())
        result = 31 * result + (webhookArn.hashCode())
        result = 31 * result + (webhookId.hashCode())
        result = 31 * result + (webhookUrl.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Webhook

        if (branchName != other.branchName) return false
        if (createTime != other.createTime) return false
        if (description != other.description) return false
        if (updateTime != other.updateTime) return false
        if (webhookArn != other.webhookArn) return false
        if (webhookId != other.webhookId) return false
        if (webhookUrl != other.webhookUrl) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amplify.model.Webhook = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name for a branch that is part of an Amplify app.
         */
        public var branchName: kotlin.String? = null
        /**
         * The create date and time for a webhook.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description for a webhook.
         */
        public var description: kotlin.String? = null
        /**
         * Updates the date and time for a webhook.
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) for the webhook.
         */
        public var webhookArn: kotlin.String? = null
        /**
         * The ID of the webhook.
         */
        public var webhookId: kotlin.String? = null
        /**
         * The URL of the webhook.
         */
        public var webhookUrl: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amplify.model.Webhook) : this() {
            this.branchName = x.branchName
            this.createTime = x.createTime
            this.description = x.description
            this.updateTime = x.updateTime
            this.webhookArn = x.webhookArn
            this.webhookId = x.webhookId
            this.webhookUrl = x.webhookUrl
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amplify.model.Webhook = Webhook(this)

        internal fun correctErrors(): Builder {
            if (branchName == null) branchName = ""
            if (createTime == null) createTime = Instant.fromEpochSeconds(0)
            if (description == null) description = ""
            if (updateTime == null) updateTime = Instant.fromEpochSeconds(0)
            if (webhookArn == null) webhookArn = ""
            if (webhookId == null) webhookId = ""
            if (webhookUrl == null) webhookUrl = ""
            return this
        }
    }
}
