// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplify.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the backend environment for an Amplify app.
 */
public class BackendEnvironment private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify app.
     */
    public val backendEnvironmentArn: kotlin.String = requireNotNull(builder.backendEnvironmentArn) { "A non-null value must be provided for backendEnvironmentArn" }
    /**
     * The creation date and time for a backend environment that is part of an Amplify app.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createTime) { "A non-null value must be provided for createTime" }
    /**
     * The name of deployment artifacts.
     */
    public val deploymentArtifacts: kotlin.String? = builder.deploymentArtifacts
    /**
     * The name for a backend environment that is part of an Amplify app.
     */
    public val environmentName: kotlin.String = requireNotNull(builder.environmentName) { "A non-null value must be provided for environmentName" }
    /**
     * The AWS CloudFormation stack name of a backend environment.
     */
    public val stackName: kotlin.String? = builder.stackName
    /**
     * The last updated date and time for a backend environment that is part of an Amplify app.
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updateTime) { "A non-null value must be provided for updateTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amplify.model.BackendEnvironment = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BackendEnvironment(")
        append("backendEnvironmentArn=$backendEnvironmentArn,")
        append("createTime=$createTime,")
        append("deploymentArtifacts=$deploymentArtifacts,")
        append("environmentName=$environmentName,")
        append("stackName=$stackName,")
        append("updateTime=$updateTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = backendEnvironmentArn.hashCode()
        result = 31 * result + (createTime.hashCode())
        result = 31 * result + (deploymentArtifacts?.hashCode() ?: 0)
        result = 31 * result + (environmentName.hashCode())
        result = 31 * result + (stackName?.hashCode() ?: 0)
        result = 31 * result + (updateTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BackendEnvironment

        if (backendEnvironmentArn != other.backendEnvironmentArn) return false
        if (createTime != other.createTime) return false
        if (deploymentArtifacts != other.deploymentArtifacts) return false
        if (environmentName != other.environmentName) return false
        if (stackName != other.stackName) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amplify.model.BackendEnvironment = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify app.
         */
        public var backendEnvironmentArn: kotlin.String? = null
        /**
         * The creation date and time for a backend environment that is part of an Amplify app.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of deployment artifacts.
         */
        public var deploymentArtifacts: kotlin.String? = null
        /**
         * The name for a backend environment that is part of an Amplify app.
         */
        public var environmentName: kotlin.String? = null
        /**
         * The AWS CloudFormation stack name of a backend environment.
         */
        public var stackName: kotlin.String? = null
        /**
         * The last updated date and time for a backend environment that is part of an Amplify app.
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amplify.model.BackendEnvironment) : this() {
            this.backendEnvironmentArn = x.backendEnvironmentArn
            this.createTime = x.createTime
            this.deploymentArtifacts = x.deploymentArtifacts
            this.environmentName = x.environmentName
            this.stackName = x.stackName
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amplify.model.BackendEnvironment = BackendEnvironment(this)

        internal fun correctErrors(): Builder {
            if (backendEnvironmentArn == null) backendEnvironmentArn = ""
            if (createTime == null) createTime = Instant.fromEpochSeconds(0)
            if (environmentName == null) environmentName = ""
            if (updateTime == null) updateTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
