// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amp.waiters

import aws.sdk.kotlin.services.amp.AmpClient
import aws.sdk.kotlin.services.amp.model.DescribeScraperRequest
import aws.sdk.kotlin.services.amp.model.DescribeScraperResponse
import aws.sdk.kotlin.services.amp.model.DescribeWorkspaceRequest
import aws.sdk.kotlin.services.amp.model.DescribeWorkspaceResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.ErrorTypeAcceptor
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import aws.smithy.kotlin.runtime.retries.policy.RetryErrorType
import kotlin.time.Duration.Companion.milliseconds


/**
 * Wait until a scraper reaches ACTIVE status
 */
public suspend fun AmpClient.waitUntilScraperActive(request: DescribeScraperRequest, retryStrategy: RetryStrategy? = null): Outcome<DescribeScraperResponse> {
    val strategy = retryStrategy ?: StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 2_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeScraperRequest, DescribeScraperResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val scraper = it.scraper
            val status = scraper?.status
            val statusCode = status?.statusCode?.value
            statusCode == "ACTIVE"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val scraper = it.scraper
            val status = scraper?.status
            val statusCode = status?.statusCode?.value
            statusCode == "CREATION_FAILED"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeScraper(request) }
}

/**
 * Wait until a scraper reaches ACTIVE status
 */
public suspend fun AmpClient.waitUntilScraperActive(block: DescribeScraperRequest.Builder.() -> Unit): Outcome<DescribeScraperResponse> =
    waitUntilScraperActive(DescribeScraperRequest.Builder().apply(block).build())

/**
 * Wait until a scraper reaches DELETED status
 */
public suspend fun AmpClient.waitUntilScraperDeleted(request: DescribeScraperRequest, retryStrategy: RetryStrategy? = null): Outcome<DescribeScraperResponse> {
    val strategy = retryStrategy ?: StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 2_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeScraperRequest, DescribeScraperResponse>>(
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "ResourceNotFoundException"),
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val scraper = it.scraper
            val status = scraper?.status
            val statusCode = status?.statusCode?.value
            statusCode == "DELETION_FAILED"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeScraper(request) }
}

/**
 * Wait until a scraper reaches DELETED status
 */
public suspend fun AmpClient.waitUntilScraperDeleted(block: DescribeScraperRequest.Builder.() -> Unit): Outcome<DescribeScraperResponse> =
    waitUntilScraperDeleted(DescribeScraperRequest.Builder().apply(block).build())

/**
 * Wait until a workspace reaches ACTIVE status
 */
public suspend fun AmpClient.waitUntilWorkspaceActive(request: DescribeWorkspaceRequest, retryStrategy: RetryStrategy? = null): Outcome<DescribeWorkspaceResponse> {
    val strategy = retryStrategy ?: StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 2_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeWorkspaceRequest, DescribeWorkspaceResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val workspace = it.workspace
            val status = workspace?.status
            val statusCode = status?.statusCode?.value
            statusCode == "ACTIVE"
        },
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val workspace = it.workspace
            val status = workspace?.status
            val statusCode = status?.statusCode?.value
            statusCode == "UPDATING"
        },
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val workspace = it.workspace
            val status = workspace?.status
            val statusCode = status?.statusCode?.value
            statusCode == "CREATING"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeWorkspace(request) }
}

/**
 * Wait until a workspace reaches ACTIVE status
 */
public suspend fun AmpClient.waitUntilWorkspaceActive(block: DescribeWorkspaceRequest.Builder.() -> Unit): Outcome<DescribeWorkspaceResponse> =
    waitUntilWorkspaceActive(DescribeWorkspaceRequest.Builder().apply(block).build())

/**
 * Wait until a workspace reaches DELETED status
 */
public suspend fun AmpClient.waitUntilWorkspaceDeleted(request: DescribeWorkspaceRequest, retryStrategy: RetryStrategy? = null): Outcome<DescribeWorkspaceResponse> {
    val strategy = retryStrategy ?: StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 2_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeWorkspaceRequest, DescribeWorkspaceResponse>>(
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "ResourceNotFoundException"),
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val workspace = it.workspace
            val status = workspace?.status
            val statusCode = status?.statusCode?.value
            statusCode == "DELETING"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeWorkspace(request) }
}

/**
 * Wait until a workspace reaches DELETED status
 */
public suspend fun AmpClient.waitUntilWorkspaceDeleted(block: DescribeWorkspaceRequest.Builder.() -> Unit): Outcome<DescribeWorkspaceResponse> =
    waitUntilWorkspaceDeleted(DescribeWorkspaceRequest.Builder().apply(block).build())
