// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amp.serde

import aws.sdk.kotlin.services.amp.model.Destination
import aws.sdk.kotlin.services.amp.model.RoleConfiguration
import aws.sdk.kotlin.services.amp.model.ScrapeConfiguration
import aws.sdk.kotlin.services.amp.model.UpdateScraperRequest
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateScraperOperationSerializer: HttpSerializer.NonStreaming<UpdateScraperRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateScraperRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.scraperId) { "scraperId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("scrapers"))
                add(PercentEncoding.SmithyLabel.encode(input.scraperId))
            }
        }

        val payload = serializeUpdateScraperOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateScraperOperationBody(context: ExecutionContext, input: UpdateScraperRequest): ByteArray {
    val serializer = JsonSerializer()
    val ALIAS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("alias"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val DESTINATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("destination"))
    val ROLECONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("roleConfiguration"))
    val SCRAPECONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("scrapeConfiguration"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALIAS_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(DESTINATION_DESCRIPTOR)
        field(ROLECONFIGURATION_DESCRIPTOR)
        field(SCRAPECONFIGURATION_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.alias?.let { field(ALIAS_DESCRIPTOR, it) }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.destination?.let { field(DESTINATION_DESCRIPTOR, it, ::serializeDestinationDocument) }
        input.roleConfiguration?.let { field(ROLECONFIGURATION_DESCRIPTOR, it, ::serializeRoleConfigurationDocument) }
        input.scrapeConfiguration?.let { field(SCRAPECONFIGURATION_DESCRIPTOR, it, ::serializeScrapeConfigurationDocument) }
    }
    return serializer.toByteArray()
}
