// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amp.serde

import aws.sdk.kotlin.services.amp.model.AmpException
import aws.sdk.kotlin.services.amp.model.DeleteScraperResponse
import aws.sdk.kotlin.services.amp.model.ScraperStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DeleteScraperOperationDeserializer: HttpDeserializer.NonStreaming<DeleteScraperResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DeleteScraperResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeleteScraperError(context, call, payload)
        }
        val builder = DeleteScraperResponse.Builder()

        if (payload != null) {
            deserializeDeleteScraperOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDeleteScraperError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw AmpException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> AmpException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteScraperOperationBody(builder: DeleteScraperResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val SCRAPERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("scraperId"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(SCRAPERID_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                SCRAPERID_DESCRIPTOR.index -> builder.scraperId = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeScraperStatusDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
