// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amp.paginators

import aws.sdk.kotlin.services.amp.AmpClient
import aws.sdk.kotlin.services.amp.model.ListRuleGroupsNamespacesRequest
import aws.sdk.kotlin.services.amp.model.ListRuleGroupsNamespacesResponse
import aws.sdk.kotlin.services.amp.model.ListScrapersRequest
import aws.sdk.kotlin.services.amp.model.ListScrapersResponse
import aws.sdk.kotlin.services.amp.model.ListWorkspacesRequest
import aws.sdk.kotlin.services.amp.model.ListWorkspacesResponse
import aws.sdk.kotlin.services.amp.model.RuleGroupsNamespaceSummary
import aws.sdk.kotlin.services.amp.model.ScraperSummary
import aws.sdk.kotlin.services.amp.model.WorkspaceSummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListRuleGroupsNamespacesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRuleGroupsNamespacesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRuleGroupsNamespacesResponse]
 */
public fun AmpClient.listRuleGroupsNamespacesPaginated(initialRequest: ListRuleGroupsNamespacesRequest): Flow<ListRuleGroupsNamespacesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRuleGroupsNamespacesPaginated.listRuleGroupsNamespaces(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListRuleGroupsNamespacesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRuleGroupsNamespacesResponse]
 */
public fun AmpClient.listRuleGroupsNamespacesPaginated(block: ListRuleGroupsNamespacesRequest.Builder.() -> Unit): Flow<ListRuleGroupsNamespacesResponse> =
    listRuleGroupsNamespacesPaginated(ListRuleGroupsNamespacesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRuleGroupsNamespacesPaginated]
 * to access the nested member [RuleGroupsNamespaceSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [RuleGroupsNamespaceSummary]
 */
@JvmName("listRuleGroupsNamespacesResponseRuleGroupsNamespaceSummary")
public fun Flow<ListRuleGroupsNamespacesResponse>.ruleGroupsNamespaces(): Flow<RuleGroupsNamespaceSummary> =
    transform() { response ->
        response.ruleGroupsNamespaces?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListScrapersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListScrapersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListScrapersResponse]
 */
public fun AmpClient.listScrapersPaginated(initialRequest: ListScrapersRequest = ListScrapersRequest { }): Flow<ListScrapersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listScrapersPaginated.listScrapers(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListScrapersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListScrapersResponse]
 */
public fun AmpClient.listScrapersPaginated(block: ListScrapersRequest.Builder.() -> Unit): Flow<ListScrapersResponse> =
    listScrapersPaginated(ListScrapersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listScrapersPaginated]
 * to access the nested member [ScraperSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ScraperSummary]
 */
@JvmName("listScrapersResponseScraperSummary")
public fun Flow<ListScrapersResponse>.scrapers(): Flow<ScraperSummary> =
    transform() { response ->
        response.scrapers?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListWorkspacesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListWorkspacesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorkspacesResponse]
 */
public fun AmpClient.listWorkspacesPaginated(initialRequest: ListWorkspacesRequest = ListWorkspacesRequest { }): Flow<ListWorkspacesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listWorkspacesPaginated.listWorkspaces(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListWorkspacesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorkspacesResponse]
 */
public fun AmpClient.listWorkspacesPaginated(block: ListWorkspacesRequest.Builder.() -> Unit): Flow<ListWorkspacesResponse> =
    listWorkspacesPaginated(ListWorkspacesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listWorkspacesPaginated]
 * to access the nested member [WorkspaceSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [WorkspaceSummary]
 */
@JvmName("listWorkspacesResponseWorkspaceSummary")
public fun Flow<ListWorkspacesResponse>.workspaces(): Flow<WorkspaceSummary> =
    transform() { response ->
        response.workspaces?.forEach {
            emit(it)
        }
    }
