// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amp.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The full details about one Amazon Managed Service for Prometheus workspace in your account.
 */
public class WorkspaceDescription private constructor(builder: Builder) {
    /**
     * The alias that is assigned to this workspace to help identify it. It does not need to be unique.
     */
    public val alias: kotlin.String? = builder.alias
    /**
     * The ARN of the workspace. For example, `arn:aws:aps:&lt;region&gt;:123456789012:workspace/ws-example1-1234-abcd-5678-ef90abcd1234`.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The date and time that the workspace was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * (optional) If the workspace was created with a customer managed KMS key, the ARN for the key used.
     */
    public val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * The Prometheus endpoint available for this workspace. For example, `https://aps-workspaces.&lt;region&gt;.amazonaws.com/workspaces/ws-example1-1234-abcd-5678-ef90abcd1234/api/v1/`.
     */
    public val prometheusEndpoint: kotlin.String? = builder.prometheusEndpoint
    /**
     * The current status of the workspace.
     */
    public val status: aws.sdk.kotlin.services.amp.model.WorkspaceStatus? = builder.status
    /**
     * The list of tag keys and values that are associated with the workspace.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The unique ID for the workspace. For example, `ws-example1-1234-abcd-5678-ef90abcd1234`.
     */
    public val workspaceId: kotlin.String = requireNotNull(builder.workspaceId) { "A non-null value must be provided for workspaceId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amp.model.WorkspaceDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WorkspaceDescription(")
        append("alias=$alias,")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("kmsKeyArn=$kmsKeyArn,")
        append("prometheusEndpoint=$prometheusEndpoint,")
        append("status=$status,")
        append("tags=$tags,")
        append("workspaceId=$workspaceId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = alias?.hashCode() ?: 0
        result = 31 * result + (arn.hashCode())
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (kmsKeyArn?.hashCode() ?: 0)
        result = 31 * result + (prometheusEndpoint?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (workspaceId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WorkspaceDescription

        if (alias != other.alias) return false
        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (kmsKeyArn != other.kmsKeyArn) return false
        if (prometheusEndpoint != other.prometheusEndpoint) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (workspaceId != other.workspaceId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amp.model.WorkspaceDescription = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The alias that is assigned to this workspace to help identify it. It does not need to be unique.
         */
        public var alias: kotlin.String? = null
        /**
         * The ARN of the workspace. For example, `arn:aws:aps:&lt;region&gt;:123456789012:workspace/ws-example1-1234-abcd-5678-ef90abcd1234`.
         */
        public var arn: kotlin.String? = null
        /**
         * The date and time that the workspace was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * (optional) If the workspace was created with a customer managed KMS key, the ARN for the key used.
         */
        public var kmsKeyArn: kotlin.String? = null
        /**
         * The Prometheus endpoint available for this workspace. For example, `https://aps-workspaces.&lt;region&gt;.amazonaws.com/workspaces/ws-example1-1234-abcd-5678-ef90abcd1234/api/v1/`.
         */
        public var prometheusEndpoint: kotlin.String? = null
        /**
         * The current status of the workspace.
         */
        public var status: aws.sdk.kotlin.services.amp.model.WorkspaceStatus? = null
        /**
         * The list of tag keys and values that are associated with the workspace.
         */
        public var tags: Map<String, String>? = null
        /**
         * The unique ID for the workspace. For example, `ws-example1-1234-abcd-5678-ef90abcd1234`.
         */
        public var workspaceId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amp.model.WorkspaceDescription) : this() {
            this.alias = x.alias
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.kmsKeyArn = x.kmsKeyArn
            this.prometheusEndpoint = x.prometheusEndpoint
            this.status = x.status
            this.tags = x.tags
            this.workspaceId = x.workspaceId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amp.model.WorkspaceDescription = WorkspaceDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.amp.model.WorkspaceStatus] inside the given [block]
         */
        public fun status(block: aws.sdk.kotlin.services.amp.model.WorkspaceStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.amp.model.WorkspaceStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (workspaceId == null) workspaceId = ""
            return this
        }
    }
}
