// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amp.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The details about one rule groups namespace.
 */
public class RuleGroupsNamespaceDescription private constructor(builder: Builder) {
    /**
     * The ARN of the rule groups namespace. For example, `arn:aws:aps:&lt;region&gt;:123456789012:rulegroupsnamespace/ws-example1-1234-abcd-5678-ef90abcd1234/rulesfile1`.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The date and time that the rule groups namespace was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The rule groups file used in the namespace.
     *
     * For details about the rule groups namespace structure, see [RuleGroupsNamespaceData](https://docs.aws.amazon.com/prometheus/latest/APIReference/yaml-RuleGroupsNamespaceData.html).
     */
    public val data: kotlin.ByteArray = requireNotNull(builder.data) { "A non-null value must be provided for data" }
    /**
     * The date and time that the rule groups namespace was most recently changed.
     */
    public val modifiedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.modifiedAt) { "A non-null value must be provided for modifiedAt" }
    /**
     * The name of the rule groups namespace.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The current status of the rule groups namespace.
     */
    public val status: aws.sdk.kotlin.services.amp.model.RuleGroupsNamespaceStatus? = builder.status
    /**
     * The list of tag keys and values that are associated with the rule groups namespace.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amp.model.RuleGroupsNamespaceDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RuleGroupsNamespaceDescription(")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("data=$data,")
        append("modifiedAt=$modifiedAt,")
        append("name=$name,")
        append("status=$status,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (data.contentHashCode())
        result = 31 * result + (modifiedAt.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RuleGroupsNamespaceDescription

        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (!data.contentEquals(other.data)) return false
        if (modifiedAt != other.modifiedAt) return false
        if (name != other.name) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amp.model.RuleGroupsNamespaceDescription = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN of the rule groups namespace. For example, `arn:aws:aps:&lt;region&gt;:123456789012:rulegroupsnamespace/ws-example1-1234-abcd-5678-ef90abcd1234/rulesfile1`.
         */
        public var arn: kotlin.String? = null
        /**
         * The date and time that the rule groups namespace was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The rule groups file used in the namespace.
         *
         * For details about the rule groups namespace structure, see [RuleGroupsNamespaceData](https://docs.aws.amazon.com/prometheus/latest/APIReference/yaml-RuleGroupsNamespaceData.html).
         */
        public var data: kotlin.ByteArray? = null
        /**
         * The date and time that the rule groups namespace was most recently changed.
         */
        public var modifiedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the rule groups namespace.
         */
        public var name: kotlin.String? = null
        /**
         * The current status of the rule groups namespace.
         */
        public var status: aws.sdk.kotlin.services.amp.model.RuleGroupsNamespaceStatus? = null
        /**
         * The list of tag keys and values that are associated with the rule groups namespace.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amp.model.RuleGroupsNamespaceDescription) : this() {
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.data = x.data
            this.modifiedAt = x.modifiedAt
            this.name = x.name
            this.status = x.status
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amp.model.RuleGroupsNamespaceDescription = RuleGroupsNamespaceDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.amp.model.RuleGroupsNamespaceStatus] inside the given [block]
         */
        public fun status(block: aws.sdk.kotlin.services.amp.model.RuleGroupsNamespaceStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.amp.model.RuleGroupsNamespaceStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (data == null) data = ByteArray(0)
            if (modifiedAt == null) modifiedAt = Instant.fromEpochSeconds(0)
            if (name == null) name = ""
            return this
        }
    }
}
