// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amp.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Use this structure to enable cross-account access, so that you can use a target account to access Prometheus metrics from source accounts.
 */
public class RoleConfiguration private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the role used in the source account to enable cross-account scraping. For information about the contents of this policy, see [Cross-account setup](https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-collector-how-to.html#cross-account-remote-write).
     */
    public val sourceRoleArn: kotlin.String? = builder.sourceRoleArn
    /**
     * The Amazon Resource Name (ARN) of the role used in the target account to enable cross-account scraping. For information about the contents of this policy, see [Cross-account setup](https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-collector-how-to.html#cross-account-remote-write).
     */
    public val targetRoleArn: kotlin.String? = builder.targetRoleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amp.model.RoleConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RoleConfiguration(")
        append("sourceRoleArn=$sourceRoleArn,")
        append("targetRoleArn=$targetRoleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = sourceRoleArn?.hashCode() ?: 0
        result = 31 * result + (targetRoleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RoleConfiguration

        if (sourceRoleArn != other.sourceRoleArn) return false
        if (targetRoleArn != other.targetRoleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amp.model.RoleConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the role used in the source account to enable cross-account scraping. For information about the contents of this policy, see [Cross-account setup](https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-collector-how-to.html#cross-account-remote-write).
         */
        public var sourceRoleArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the role used in the target account to enable cross-account scraping. For information about the contents of this policy, see [Cross-account setup](https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-collector-how-to.html#cross-account-remote-write).
         */
        public var targetRoleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amp.model.RoleConfiguration) : this() {
            this.sourceRoleArn = x.sourceRoleArn
            this.targetRoleArn = x.targetRoleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amp.model.RoleConfiguration = RoleConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
