// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amp.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The metadata for a query logging configuration.
 */
public class QueryLoggingConfigurationMetadata private constructor(builder: Builder) {
    /**
     * The date and time when the query logging configuration was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The configured destinations for the query logging configuration.
     */
    public val destinations: List<LoggingDestination> = requireNotNull(builder.destinations) { "A non-null value must be provided for destinations" }
    /**
     * The date and time when the query logging configuration was last modified.
     */
    public val modifiedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.modifiedAt) { "A non-null value must be provided for modifiedAt" }
    /**
     * The current status of the query logging configuration.
     */
    public val status: aws.sdk.kotlin.services.amp.model.QueryLoggingConfigurationStatus? = builder.status
    /**
     * The ID of the workspace associated with this query logging configuration.
     */
    public val workspace: kotlin.String = requireNotNull(builder.workspace) { "A non-null value must be provided for workspace" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amp.model.QueryLoggingConfigurationMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QueryLoggingConfigurationMetadata(")
        append("createdAt=$createdAt,")
        append("destinations=$destinations,")
        append("modifiedAt=$modifiedAt,")
        append("status=$status,")
        append("workspace=$workspace")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt.hashCode()
        result = 31 * result + (destinations.hashCode())
        result = 31 * result + (modifiedAt.hashCode())
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (workspace.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QueryLoggingConfigurationMetadata

        if (createdAt != other.createdAt) return false
        if (destinations != other.destinations) return false
        if (modifiedAt != other.modifiedAt) return false
        if (status != other.status) return false
        if (workspace != other.workspace) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amp.model.QueryLoggingConfigurationMetadata = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date and time when the query logging configuration was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The configured destinations for the query logging configuration.
         */
        public var destinations: List<LoggingDestination>? = null
        /**
         * The date and time when the query logging configuration was last modified.
         */
        public var modifiedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The current status of the query logging configuration.
         */
        public var status: aws.sdk.kotlin.services.amp.model.QueryLoggingConfigurationStatus? = null
        /**
         * The ID of the workspace associated with this query logging configuration.
         */
        public var workspace: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amp.model.QueryLoggingConfigurationMetadata) : this() {
            this.createdAt = x.createdAt
            this.destinations = x.destinations
            this.modifiedAt = x.modifiedAt
            this.status = x.status
            this.workspace = x.workspace
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amp.model.QueryLoggingConfigurationMetadata = QueryLoggingConfigurationMetadata(this)

        /**
         * construct an [aws.sdk.kotlin.services.amp.model.QueryLoggingConfigurationStatus] inside the given [block]
         */
        public fun status(block: aws.sdk.kotlin.services.amp.model.QueryLoggingConfigurationStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.amp.model.QueryLoggingConfigurationStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (destinations == null) destinations = emptyList()
            if (modifiedAt == null) modifiedAt = Instant.fromEpochSeconds(0)
            if (workspace == null) workspace = ""
            return this
        }
    }
}
