// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amp.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents the input of a `PutAlertManagerDefinition` operation.
 */
public class PutAlertManagerDefinitionRequest private constructor(builder: Builder) {
    /**
     * A unique identifier that you can provide to ensure the idempotency of the request. Case-sensitive.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The alert manager definition to use. A base64-encoded version of the YAML alert manager definition file.
     *
     * For details about the alert manager definition, see [AlertManagedDefinitionData](https://docs.aws.amazon.com/prometheus/latest/APIReference/yaml-AlertManagerDefinitionData.html).
     */
    public val data: kotlin.ByteArray = requireNotNull(builder.data) { "A non-null value must be provided for data" }
    /**
     * The ID of the workspace to update the alert manager definition in.
     */
    public val workspaceId: kotlin.String = requireNotNull(builder.workspaceId) { "A non-null value must be provided for workspaceId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amp.model.PutAlertManagerDefinitionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutAlertManagerDefinitionRequest(")
        append("clientToken=$clientToken,")
        append("data=$data,")
        append("workspaceId=$workspaceId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (data.contentHashCode())
        result = 31 * result + (workspaceId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutAlertManagerDefinitionRequest

        if (clientToken != other.clientToken) return false
        if (!data.contentEquals(other.data)) return false
        if (workspaceId != other.workspaceId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amp.model.PutAlertManagerDefinitionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A unique identifier that you can provide to ensure the idempotency of the request. Case-sensitive.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The alert manager definition to use. A base64-encoded version of the YAML alert manager definition file.
         *
         * For details about the alert manager definition, see [AlertManagedDefinitionData](https://docs.aws.amazon.com/prometheus/latest/APIReference/yaml-AlertManagerDefinitionData.html).
         */
        public var data: kotlin.ByteArray? = null
        /**
         * The ID of the workspace to update the alert manager definition in.
         */
        public var workspaceId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amp.model.PutAlertManagerDefinitionRequest) : this() {
            this.clientToken = x.clientToken
            this.data = x.data
            this.workspaceId = x.workspaceId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amp.model.PutAlertManagerDefinitionRequest = PutAlertManagerDefinitionRequest(this)

        internal fun correctErrors(): Builder {
            if (data == null) data = ByteArray(0)
            if (workspaceId == null) workspaceId = ""
            return this
        }
    }
}
