// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amp.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents the input of a `ListScrapers` operation.
 */
public class ListScrapersRequest private constructor(builder: Builder) {
    /**
     * (Optional) A list of key-value pairs to filter the list of scrapers returned. Keys include `status`, `sourceArn`, `destinationArn`, and `alias`.
     *
     * Filters on the same key are `OR`'d together, and filters on different keys are `AND`'d together. For example, `status=ACTIVE&amp;status=CREATING&amp;alias=Test`, will return all scrapers that have the alias Test, and are either in status ACTIVE or CREATING.
     *
     * To find all active scrapers that are sending metrics to a specific Amazon Managed Service for Prometheus workspace, you would use the ARN of the workspace in a query:
     *
     * `status=ACTIVE&amp;destinationArn=arn:aws:aps:us-east-1:123456789012:workspace/ws-example1-1234-abcd-56ef-123456789012`
     *
     * If this is included, it filters the results to only the scrapers that match the filter.
     */
    public val filters: Map<String, List<String>>? = builder.filters
    /**
     * Optional) The maximum number of scrapers to return in one `ListScrapers` operation. The range is 1-1000.
     *
     * If you omit this parameter, the default of 100 is used.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * (Optional) The token for the next set of items to return. (You received this token from a previous call.)
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amp.model.ListScrapersRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListScrapersRequest(")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = filters?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListScrapersRequest

        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amp.model.ListScrapersRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * (Optional) A list of key-value pairs to filter the list of scrapers returned. Keys include `status`, `sourceArn`, `destinationArn`, and `alias`.
         *
         * Filters on the same key are `OR`'d together, and filters on different keys are `AND`'d together. For example, `status=ACTIVE&amp;status=CREATING&amp;alias=Test`, will return all scrapers that have the alias Test, and are either in status ACTIVE or CREATING.
         *
         * To find all active scrapers that are sending metrics to a specific Amazon Managed Service for Prometheus workspace, you would use the ARN of the workspace in a query:
         *
         * `status=ACTIVE&amp;destinationArn=arn:aws:aps:us-east-1:123456789012:workspace/ws-example1-1234-abcd-56ef-123456789012`
         *
         * If this is included, it filters the results to only the scrapers that match the filter.
         */
        public var filters: Map<String, List<String>>? = null
        /**
         * Optional) The maximum number of scrapers to return in one `ListScrapers` operation. The range is 1-1000.
         *
         * If you omit this parameter, the default of 100 is used.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * (Optional) The token for the next set of items to return. (You received this token from a previous call.)
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amp.model.ListScrapersRequest) : this() {
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amp.model.ListScrapersRequest = ListScrapersRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
