// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amp.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This structure defines one label set used to enforce active time series limits for the workspace, and defines the limit for that label set.
 *
 * A label set is a unique combination of label-value pairs. Use them to control time series limits and to monitor usage by specific label groups. Example label sets might be `team:finance` or `env:prod`
 */
public class LimitsPerLabelSet private constructor(builder: Builder) {
    /**
     * This defines one label set that will have an enforced active time series limit.
     *
     * Label values accept ASCII characters and must contain at least one character that isn't whitespace. ASCII control characters are not accepted. If the label name is metric name label `__<i>name</i>__`, then the *metric* part of the name must conform to the following pattern: `[a-zA-Z_:][a-zA-Z0-9_:]*`
     */
    public val labelSet: Map<String, String> = requireNotNull(builder.labelSet) { "A non-null value must be provided for labelSet" }
    /**
     * This structure contains the information about the limits that apply to time series that match this label set.
     */
    public val limits: aws.sdk.kotlin.services.amp.model.LimitsPerLabelSetEntry? = builder.limits

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amp.model.LimitsPerLabelSet = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LimitsPerLabelSet(")
        append("labelSet=$labelSet,")
        append("limits=$limits")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = labelSet.hashCode()
        result = 31 * result + (limits?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LimitsPerLabelSet

        if (labelSet != other.labelSet) return false
        if (limits != other.limits) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amp.model.LimitsPerLabelSet = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * This defines one label set that will have an enforced active time series limit.
         *
         * Label values accept ASCII characters and must contain at least one character that isn't whitespace. ASCII control characters are not accepted. If the label name is metric name label `__<i>name</i>__`, then the *metric* part of the name must conform to the following pattern: `[a-zA-Z_:][a-zA-Z0-9_:]*`
         */
        public var labelSet: Map<String, String>? = null
        /**
         * This structure contains the information about the limits that apply to time series that match this label set.
         */
        public var limits: aws.sdk.kotlin.services.amp.model.LimitsPerLabelSetEntry? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amp.model.LimitsPerLabelSet) : this() {
            this.labelSet = x.labelSet
            this.limits = x.limits
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amp.model.LimitsPerLabelSet = LimitsPerLabelSet(this)

        /**
         * construct an [aws.sdk.kotlin.services.amp.model.LimitsPerLabelSetEntry] inside the given [block]
         */
        public fun limits(block: aws.sdk.kotlin.services.amp.model.LimitsPerLabelSetEntry.Builder.() -> kotlin.Unit) {
            this.limits = aws.sdk.kotlin.services.amp.model.LimitsPerLabelSetEntry.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (labelSet == null) labelSet = emptyMap()
            return this
        }
    }
}
