// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amp.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The `EksConfiguration` structure describes the connection to the Amazon EKS cluster from which a scraper collects metrics.
 */
public class EksConfiguration private constructor(builder: Builder) {
    /**
     * ARN of the Amazon EKS cluster.
     */
    public val clusterArn: kotlin.String = requireNotNull(builder.clusterArn) { "A non-null value must be provided for clusterArn" }
    /**
     * A list of the security group IDs for the Amazon EKS cluster VPC configuration.
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * A list of subnet IDs for the Amazon EKS cluster VPC configuration.
     */
    public val subnetIds: List<String> = requireNotNull(builder.subnetIds) { "A non-null value must be provided for subnetIds" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amp.model.EksConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EksConfiguration(")
        append("clusterArn=$clusterArn,")
        append("securityGroupIds=$securityGroupIds,")
        append("subnetIds=$subnetIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterArn.hashCode()
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (subnetIds.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EksConfiguration

        if (clusterArn != other.clusterArn) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (subnetIds != other.subnetIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amp.model.EksConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * ARN of the Amazon EKS cluster.
         */
        public var clusterArn: kotlin.String? = null
        /**
         * A list of the security group IDs for the Amazon EKS cluster VPC configuration.
         */
        public var securityGroupIds: List<String>? = null
        /**
         * A list of subnet IDs for the Amazon EKS cluster VPC configuration.
         */
        public var subnetIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amp.model.EksConfiguration) : this() {
            this.clusterArn = x.clusterArn
            this.securityGroupIds = x.securityGroupIds
            this.subnetIds = x.subnetIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amp.model.EksConfiguration = EksConfiguration(this)

        internal fun correctErrors(): Builder {
            if (clusterArn == null) clusterArn = ""
            if (subnetIds == null) subnetIds = emptyList()
            return this
        }
    }
}
