// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amp.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents the output of a `CreateWorkspace` operation.
 */
public class CreateWorkspaceResponse private constructor(builder: Builder) {
    /**
     * The ARN for the new workspace.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * (optional) If the workspace was created with a customer managed KMS key, the ARN for the key used.
     */
    public val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * The current status of the new workspace. Immediately after you create the workspace, the status is usually `CREATING`.
     */
    public val status: aws.sdk.kotlin.services.amp.model.WorkspaceStatus? = builder.status
    /**
     * The list of tag keys and values that are associated with the workspace.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The unique ID for the new workspace.
     */
    public val workspaceId: kotlin.String = requireNotNull(builder.workspaceId) { "A non-null value must be provided for workspaceId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amp.model.CreateWorkspaceResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateWorkspaceResponse(")
        append("arn=$arn,")
        append("kmsKeyArn=$kmsKeyArn,")
        append("status=$status,")
        append("tags=$tags,")
        append("workspaceId=$workspaceId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (kmsKeyArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (workspaceId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateWorkspaceResponse

        if (arn != other.arn) return false
        if (kmsKeyArn != other.kmsKeyArn) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (workspaceId != other.workspaceId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amp.model.CreateWorkspaceResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN for the new workspace.
         */
        public var arn: kotlin.String? = null
        /**
         * (optional) If the workspace was created with a customer managed KMS key, the ARN for the key used.
         */
        public var kmsKeyArn: kotlin.String? = null
        /**
         * The current status of the new workspace. Immediately after you create the workspace, the status is usually `CREATING`.
         */
        public var status: aws.sdk.kotlin.services.amp.model.WorkspaceStatus? = null
        /**
         * The list of tag keys and values that are associated with the workspace.
         */
        public var tags: Map<String, String>? = null
        /**
         * The unique ID for the new workspace.
         */
        public var workspaceId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amp.model.CreateWorkspaceResponse) : this() {
            this.arn = x.arn
            this.kmsKeyArn = x.kmsKeyArn
            this.status = x.status
            this.tags = x.tags
            this.workspaceId = x.workspaceId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amp.model.CreateWorkspaceResponse = CreateWorkspaceResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.amp.model.WorkspaceStatus] inside the given [block]
         */
        public fun status(block: aws.sdk.kotlin.services.amp.model.WorkspaceStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.amp.model.WorkspaceStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (workspaceId == null) workspaceId = ""
            return this
        }
    }
}
