// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amp.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents the input of a `CreateScraper` operation.
 */
public class CreateScraperRequest private constructor(builder: Builder) {
    /**
     * (optional) An alias to associate with the scraper. This is for your use, and does not need to be unique.
     */
    public val alias: kotlin.String? = builder.alias
    /**
     * (Optional) A unique, case-sensitive identifier that you can provide to ensure the idempotency of the request.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The Amazon Managed Service for Prometheus workspace to send metrics to.
     */
    public val destination: aws.sdk.kotlin.services.amp.model.Destination? = builder.destination
    /**
     * Use this structure to enable cross-account access, so that you can use a target account to access Prometheus metrics from source accounts.
     */
    public val roleConfiguration: aws.sdk.kotlin.services.amp.model.RoleConfiguration? = builder.roleConfiguration
    /**
     * The configuration file to use in the new scraper. For more information, see [Scraper configuration](https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-collector-how-to.html#AMP-collector-configuration) in the *Amazon Managed Service for Prometheus User Guide*.
     */
    public val scrapeConfiguration: aws.sdk.kotlin.services.amp.model.ScrapeConfiguration? = builder.scrapeConfiguration
    /**
     * The Amazon EKS cluster from which the scraper will collect metrics.
     */
    public val source: aws.sdk.kotlin.services.amp.model.Source? = builder.source
    /**
     * (Optional) The list of tag keys and values to associate with the scraper.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amp.model.CreateScraperRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateScraperRequest(")
        append("alias=$alias,")
        append("clientToken=$clientToken,")
        append("destination=$destination,")
        append("roleConfiguration=$roleConfiguration,")
        append("scrapeConfiguration=$scrapeConfiguration,")
        append("source=$source,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = alias?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (destination?.hashCode() ?: 0)
        result = 31 * result + (roleConfiguration?.hashCode() ?: 0)
        result = 31 * result + (scrapeConfiguration?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateScraperRequest

        if (alias != other.alias) return false
        if (clientToken != other.clientToken) return false
        if (destination != other.destination) return false
        if (roleConfiguration != other.roleConfiguration) return false
        if (scrapeConfiguration != other.scrapeConfiguration) return false
        if (source != other.source) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amp.model.CreateScraperRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * (optional) An alias to associate with the scraper. This is for your use, and does not need to be unique.
         */
        public var alias: kotlin.String? = null
        /**
         * (Optional) A unique, case-sensitive identifier that you can provide to ensure the idempotency of the request.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The Amazon Managed Service for Prometheus workspace to send metrics to.
         */
        public var destination: aws.sdk.kotlin.services.amp.model.Destination? = null
        /**
         * Use this structure to enable cross-account access, so that you can use a target account to access Prometheus metrics from source accounts.
         */
        public var roleConfiguration: aws.sdk.kotlin.services.amp.model.RoleConfiguration? = null
        /**
         * The configuration file to use in the new scraper. For more information, see [Scraper configuration](https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-collector-how-to.html#AMP-collector-configuration) in the *Amazon Managed Service for Prometheus User Guide*.
         */
        public var scrapeConfiguration: aws.sdk.kotlin.services.amp.model.ScrapeConfiguration? = null
        /**
         * The Amazon EKS cluster from which the scraper will collect metrics.
         */
        public var source: aws.sdk.kotlin.services.amp.model.Source? = null
        /**
         * (Optional) The list of tag keys and values to associate with the scraper.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amp.model.CreateScraperRequest) : this() {
            this.alias = x.alias
            this.clientToken = x.clientToken
            this.destination = x.destination
            this.roleConfiguration = x.roleConfiguration
            this.scrapeConfiguration = x.scrapeConfiguration
            this.source = x.source
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amp.model.CreateScraperRequest = CreateScraperRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.amp.model.RoleConfiguration] inside the given [block]
         */
        public fun roleConfiguration(block: aws.sdk.kotlin.services.amp.model.RoleConfiguration.Builder.() -> kotlin.Unit) {
            this.roleConfiguration = aws.sdk.kotlin.services.amp.model.RoleConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
