// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amp.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents the input of a `CreateRuleGroupsNamespace` operation.
 */
public class CreateRuleGroupsNamespaceRequest private constructor(builder: Builder) {
    /**
     * A unique identifier that you can provide to ensure the idempotency of the request. Case-sensitive.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The rules file to use in the new namespace.
     *
     * Contains the base64-encoded version of the YAML rules file.
     *
     * For details about the rule groups namespace structure, see [RuleGroupsNamespaceData](https://docs.aws.amazon.com/prometheus/latest/APIReference/yaml-RuleGroupsNamespaceData.html).
     */
    public val data: kotlin.ByteArray = requireNotNull(builder.data) { "A non-null value must be provided for data" }
    /**
     * The name for the new rule groups namespace.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The list of tag keys and values to associate with the rule groups namespace.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The ID of the workspace to add the rule groups namespace.
     */
    public val workspaceId: kotlin.String = requireNotNull(builder.workspaceId) { "A non-null value must be provided for workspaceId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amp.model.CreateRuleGroupsNamespaceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateRuleGroupsNamespaceRequest(")
        append("clientToken=$clientToken,")
        append("data=$data,")
        append("name=$name,")
        append("tags=$tags,")
        append("workspaceId=$workspaceId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (data.contentHashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (workspaceId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateRuleGroupsNamespaceRequest

        if (clientToken != other.clientToken) return false
        if (!data.contentEquals(other.data)) return false
        if (name != other.name) return false
        if (tags != other.tags) return false
        if (workspaceId != other.workspaceId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amp.model.CreateRuleGroupsNamespaceRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A unique identifier that you can provide to ensure the idempotency of the request. Case-sensitive.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The rules file to use in the new namespace.
         *
         * Contains the base64-encoded version of the YAML rules file.
         *
         * For details about the rule groups namespace structure, see [RuleGroupsNamespaceData](https://docs.aws.amazon.com/prometheus/latest/APIReference/yaml-RuleGroupsNamespaceData.html).
         */
        public var data: kotlin.ByteArray? = null
        /**
         * The name for the new rule groups namespace.
         */
        public var name: kotlin.String? = null
        /**
         * The list of tag keys and values to associate with the rule groups namespace.
         */
        public var tags: Map<String, String>? = null
        /**
         * The ID of the workspace to add the rule groups namespace.
         */
        public var workspaceId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amp.model.CreateRuleGroupsNamespaceRequest) : this() {
            this.clientToken = x.clientToken
            this.data = x.data
            this.name = x.name
            this.tags = x.tags
            this.workspaceId = x.workspaceId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amp.model.CreateRuleGroupsNamespaceRequest = CreateRuleGroupsNamespaceRequest(this)

        internal fun correctErrors(): Builder {
            if (data == null) data = ByteArray(0)
            if (name == null) name = ""
            if (workspaceId == null) workspaceId = ""
            return this
        }
    }
}
