// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amp.serde

import aws.sdk.kotlin.services.amp.model.CreateScraperRequest
import aws.sdk.kotlin.services.amp.model.Destination
import aws.sdk.kotlin.services.amp.model.ScrapeConfiguration
import aws.sdk.kotlin.services.amp.model.Source
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateScraperOperationSerializer: HttpSerializer.NonStreaming<CreateScraperRequest> {
    override fun serialize(context: ExecutionContext, input: CreateScraperRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/scrapers"
        }

        val payload = serializeCreateScraperOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateScraperOperationBody(context: ExecutionContext, input: CreateScraperRequest): ByteArray {
    val serializer = JsonSerializer()
    val ALIAS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("alias"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val DESTINATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("destination"))
    val SCRAPECONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("scrapeConfiguration"))
    val SOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("source"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALIAS_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(DESTINATION_DESCRIPTOR)
        field(SCRAPECONFIGURATION_DESCRIPTOR)
        field(SOURCE_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.alias?.let { field(ALIAS_DESCRIPTOR, it) }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.destination?.let { field(DESTINATION_DESCRIPTOR, it, ::serializeDestinationDocument) }
        input.scrapeConfiguration?.let { field(SCRAPECONFIGURATION_DESCRIPTOR, it, ::serializeScrapeConfigurationDocument) }
        input.source?.let { field(SOURCE_DESCRIPTOR, it, ::serializeSourceDocument) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) -> entry(key, value) }
            }
        }
    }
    return serializer.toByteArray()
}
