// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amp.model

import aws.smithy.kotlin.runtime.ErrorMetadata
import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.ServiceErrorMetadata

/**
 * The request was denied due to request throttling.
 */
public class ThrottlingException private constructor(builder: Builder) : AmpException(builder.message) {

    /**
     * Service quotas code for the originating quota.
     */
    public val quotaCode: kotlin.String? = builder.quotaCode
    /**
     * Advice to clients on when the call can be safely retried.
     */
    public val retryAfterSeconds: kotlin.Int? = builder.retryAfterSeconds
    /**
     * Service quotas code for the originating service.
     */
    public val serviceCode: kotlin.String? = builder.serviceCode

    init {
        sdkErrorMetadata.attributes[ErrorMetadata.Retryable] = true
        sdkErrorMetadata.attributes[ErrorMetadata.ThrottlingError] = false
        sdkErrorMetadata.attributes[ServiceErrorMetadata.ErrorType] = ErrorType.Client
    }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amp.model.ThrottlingException = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ThrottlingException(")
        append("message=$message,")
        append("quotaCode=$quotaCode,")
        append("retryAfterSeconds=$retryAfterSeconds,")
        append("serviceCode=$serviceCode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = message.hashCode()
        result = 31 * result + (quotaCode?.hashCode() ?: 0)
        result = 31 * result + (retryAfterSeconds ?: 0)
        result = 31 * result + (serviceCode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ThrottlingException

        if (message != other.message) return false
        if (quotaCode != other.quotaCode) return false
        if (retryAfterSeconds != other.retryAfterSeconds) return false
        if (serviceCode != other.serviceCode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amp.model.ThrottlingException = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Description of the error.
         */
        public var message: kotlin.String? = null
        /**
         * Service quotas code for the originating quota.
         */
        public var quotaCode: kotlin.String? = null
        /**
         * Advice to clients on when the call can be safely retried.
         */
        public var retryAfterSeconds: kotlin.Int? = null
        /**
         * Service quotas code for the originating service.
         */
        public var serviceCode: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amp.model.ThrottlingException) : this() {
            this.message = x.message
            this.quotaCode = x.quotaCode
            this.retryAfterSeconds = x.retryAfterSeconds
            this.serviceCode = x.serviceCode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amp.model.ThrottlingException = ThrottlingException(this)

        internal fun correctErrors(): Builder {
            if (message == null) message = ""
            return this
        }
    }
}
