// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amp.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The `ScraperSummary` structure contains a summary of the details about one scraper in your account.
 */
public class ScraperSummary private constructor(builder: Builder) {
    /**
     * (Optional) A name associated with the scraper.
     */
    public val alias: kotlin.String? = builder.alias
    /**
     * The Amazon Resource Name (ARN) of the scraper.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The date and time that the scraper was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The Amazon Managed Service for Prometheus workspace the scraper sends metrics to.
     */
    public val destination: aws.sdk.kotlin.services.amp.model.Destination? = builder.destination
    /**
     * The date and time that the scraper was last modified.
     */
    public val lastModifiedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastModifiedAt) { "A non-null value must be provided for lastModifiedAt" }
    /**
     * The Amazon Resource Name (ARN) of the IAM role that provides permissions for the scraper to discover and collect metrics on your behalf.
     */
    public val roleArn: kotlin.String = requireNotNull(builder.roleArn) { "A non-null value must be provided for roleArn" }
    /**
     * The ID of the scraper.
     */
    public val scraperId: kotlin.String = requireNotNull(builder.scraperId) { "A non-null value must be provided for scraperId" }
    /**
     * The Amazon EKS cluster from which the scraper collects metrics.
     */
    public val source: aws.sdk.kotlin.services.amp.model.Source? = builder.source
    /**
     * A structure that contains the current status of the scraper.
     */
    public val status: aws.sdk.kotlin.services.amp.model.ScraperStatus? = builder.status
    /**
     * If there is a failure, the reason for the failure.
     */
    public val statusReason: kotlin.String? = builder.statusReason
    /**
     * (Optional) The list of tag keys and values associated with the scraper.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amp.model.ScraperSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ScraperSummary(")
        append("alias=$alias,")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("destination=$destination,")
        append("lastModifiedAt=$lastModifiedAt,")
        append("roleArn=$roleArn,")
        append("scraperId=$scraperId,")
        append("source=$source,")
        append("status=$status,")
        append("statusReason=$statusReason,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = alias?.hashCode() ?: 0
        result = 31 * result + (arn.hashCode())
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (destination?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedAt.hashCode())
        result = 31 * result + (roleArn.hashCode())
        result = 31 * result + (scraperId.hashCode())
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ScraperSummary

        if (alias != other.alias) return false
        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (destination != other.destination) return false
        if (lastModifiedAt != other.lastModifiedAt) return false
        if (roleArn != other.roleArn) return false
        if (scraperId != other.scraperId) return false
        if (source != other.source) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amp.model.ScraperSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * (Optional) A name associated with the scraper.
         */
        public var alias: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the scraper.
         */
        public var arn: kotlin.String? = null
        /**
         * The date and time that the scraper was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Managed Service for Prometheus workspace the scraper sends metrics to.
         */
        public var destination: aws.sdk.kotlin.services.amp.model.Destination? = null
        /**
         * The date and time that the scraper was last modified.
         */
        public var lastModifiedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role that provides permissions for the scraper to discover and collect metrics on your behalf.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The ID of the scraper.
         */
        public var scraperId: kotlin.String? = null
        /**
         * The Amazon EKS cluster from which the scraper collects metrics.
         */
        public var source: aws.sdk.kotlin.services.amp.model.Source? = null
        /**
         * A structure that contains the current status of the scraper.
         */
        public var status: aws.sdk.kotlin.services.amp.model.ScraperStatus? = null
        /**
         * If there is a failure, the reason for the failure.
         */
        public var statusReason: kotlin.String? = null
        /**
         * (Optional) The list of tag keys and values associated with the scraper.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amp.model.ScraperSummary) : this() {
            this.alias = x.alias
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.destination = x.destination
            this.lastModifiedAt = x.lastModifiedAt
            this.roleArn = x.roleArn
            this.scraperId = x.scraperId
            this.source = x.source
            this.status = x.status
            this.statusReason = x.statusReason
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amp.model.ScraperSummary = ScraperSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.amp.model.ScraperStatus] inside the given [block]
         */
        public fun status(block: aws.sdk.kotlin.services.amp.model.ScraperStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.amp.model.ScraperStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (lastModifiedAt == null) lastModifiedAt = Instant.fromEpochSeconds(0)
            if (roleArn == null) roleArn = ""
            if (scraperId == null) scraperId = ""
            return this
        }
    }
}
