// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amp.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The high-level information about a rule groups namespace. To retrieve more information, use `DescribeRuleGroupsNamespace`.
 */
public class RuleGroupsNamespaceSummary private constructor(builder: Builder) {
    /**
     * The ARN of the rule groups namespace.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The date and time that the rule groups namespace was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The date and time that the rule groups namespace was most recently changed.
     */
    public val modifiedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.modifiedAt) { "A non-null value must be provided for modifiedAt" }
    /**
     * The name of the rule groups namespace.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * A structure that displays the current status of the rule groups namespace.
     */
    public val status: aws.sdk.kotlin.services.amp.model.RuleGroupsNamespaceStatus? = builder.status
    /**
     * The list of tag keys and values that are associated with the rule groups namespace.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amp.model.RuleGroupsNamespaceSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RuleGroupsNamespaceSummary(")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("modifiedAt=$modifiedAt,")
        append("name=$name,")
        append("status=$status,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (modifiedAt.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RuleGroupsNamespaceSummary

        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (modifiedAt != other.modifiedAt) return false
        if (name != other.name) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amp.model.RuleGroupsNamespaceSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN of the rule groups namespace.
         */
        public var arn: kotlin.String? = null
        /**
         * The date and time that the rule groups namespace was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date and time that the rule groups namespace was most recently changed.
         */
        public var modifiedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the rule groups namespace.
         */
        public var name: kotlin.String? = null
        /**
         * A structure that displays the current status of the rule groups namespace.
         */
        public var status: aws.sdk.kotlin.services.amp.model.RuleGroupsNamespaceStatus? = null
        /**
         * The list of tag keys and values that are associated with the rule groups namespace.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amp.model.RuleGroupsNamespaceSummary) : this() {
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.modifiedAt = x.modifiedAt
            this.name = x.name
            this.status = x.status
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amp.model.RuleGroupsNamespaceSummary = RuleGroupsNamespaceSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.amp.model.RuleGroupsNamespaceStatus] inside the given [block]
         */
        public fun status(block: aws.sdk.kotlin.services.amp.model.RuleGroupsNamespaceStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.amp.model.RuleGroupsNamespaceStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (modifiedAt == null) modifiedAt = Instant.fromEpochSeconds(0)
            if (name == null) name = ""
            return this
        }
    }
}
