// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amp.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents the input of a `PutRuleGroupsNamespace` operation.
 */
public class PutRuleGroupsNamespaceRequest private constructor(builder: Builder) {
    /**
     * A unique identifier that you can provide to ensure the idempotency of the request. Case-sensitive.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The new rules file to use in the namespace. A base64-encoded version of the YAML rule groups file.
     *
     * For details about the rule groups namespace structure, see [RuleGroupsNamespaceData](https://docs.aws.amazon.com/prometheus/latest/APIReference/yaml-RuleGroupsNamespaceData.html).
     */
    public val data: kotlin.ByteArray = requireNotNull(builder.data) { "A non-null value must be provided for data" }
    /**
     * The name of the rule groups namespace that you are updating.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The ID of the workspace where you are updating the rule groups namespace.
     */
    public val workspaceId: kotlin.String = requireNotNull(builder.workspaceId) { "A non-null value must be provided for workspaceId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amp.model.PutRuleGroupsNamespaceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutRuleGroupsNamespaceRequest(")
        append("clientToken=$clientToken,")
        append("data=$data,")
        append("name=$name,")
        append("workspaceId=$workspaceId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (data.contentHashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (workspaceId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutRuleGroupsNamespaceRequest

        if (clientToken != other.clientToken) return false
        if (data != null) {
            if (other.data == null) return false
            if (!data.contentEquals(other.data)) return false
        } else if (other.data != null) return false
        if (name != other.name) return false
        if (workspaceId != other.workspaceId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amp.model.PutRuleGroupsNamespaceRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A unique identifier that you can provide to ensure the idempotency of the request. Case-sensitive.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The new rules file to use in the namespace. A base64-encoded version of the YAML rule groups file.
         *
         * For details about the rule groups namespace structure, see [RuleGroupsNamespaceData](https://docs.aws.amazon.com/prometheus/latest/APIReference/yaml-RuleGroupsNamespaceData.html).
         */
        public var data: kotlin.ByteArray? = null
        /**
         * The name of the rule groups namespace that you are updating.
         */
        public var name: kotlin.String? = null
        /**
         * The ID of the workspace where you are updating the rule groups namespace.
         */
        public var workspaceId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amp.model.PutRuleGroupsNamespaceRequest) : this() {
            this.clientToken = x.clientToken
            this.data = x.data
            this.name = x.name
            this.workspaceId = x.workspaceId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amp.model.PutRuleGroupsNamespaceRequest = PutRuleGroupsNamespaceRequest(this)

        internal fun correctErrors(): Builder {
            if (data == null) data = ByteArray(0)
            if (name == null) name = ""
            if (workspaceId == null) workspaceId = ""
            return this
        }
    }
}
