// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amp.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents the input of a `ListWorkspaces` operation.
 */
public class ListWorkspacesRequest private constructor(builder: Builder) {
    /**
     * If this is included, it filters the results to only the workspaces with names that start with the value that you specify here.
     *
     * Amazon Managed Service for Prometheus will automatically strip any blank spaces from the beginning and end of the alias that you specify.
     */
    public val alias: kotlin.String? = builder.alias
    /**
     * The maximum number of workspaces to return per request. The default is 100.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token for the next set of items to return. You receive this token from a previous call, and use it to get the next page of results. The other parameters must be the same as the initial call.
     *
     * For example, if your initial request has `maxResults` of 10, and there are 12 workspaces to return, then your initial request will return 10 and a `nextToken`. Using the next token in a subsequent call will return the remaining 2 workspaces.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amp.model.ListWorkspacesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListWorkspacesRequest(")
        append("alias=$alias,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = alias?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListWorkspacesRequest

        if (alias != other.alias) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amp.model.ListWorkspacesRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * If this is included, it filters the results to only the workspaces with names that start with the value that you specify here.
         *
         * Amazon Managed Service for Prometheus will automatically strip any blank spaces from the beginning and end of the alias that you specify.
         */
        public var alias: kotlin.String? = null
        /**
         * The maximum number of workspaces to return per request. The default is 100.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token for the next set of items to return. You receive this token from a previous call, and use it to get the next page of results. The other parameters must be the same as the initial call.
         *
         * For example, if your initial request has `maxResults` of 10, and there are 12 workspaces to return, then your initial request will return 10 and a `nextToken`. Using the next token in a subsequent call will return the remaining 2 workspaces.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amp.model.ListWorkspacesRequest) : this() {
            this.alias = x.alias
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amp.model.ListWorkspacesRequest = ListWorkspacesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
