// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amp.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents the input of a `CreateWorkspace` operation.
 */
public class CreateWorkspaceRequest private constructor(builder: Builder) {
    /**
     * An alias that you assign to this workspace to help you identify it. It does not need to be unique.
     *
     * Blank spaces at the beginning or end of the alias that you specify will be trimmed from the value used.
     */
    public val alias: kotlin.String? = builder.alias
    /**
     * A unique identifier that you can provide to ensure the idempotency of the request. Case-sensitive.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * (optional) The ARN for a customer managed KMS key to use for encrypting data within your workspace. For more information about using your own key in your workspace, see [Encryption at rest](https://docs.aws.amazon.com/prometheus/latest/userguide/encryption-at-rest-Amazon-Service-Prometheus.html) in the *Amazon Managed Service for Prometheus User Guide*.
     */
    public val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * The list of tag keys and values to associate with the workspace.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amp.model.CreateWorkspaceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateWorkspaceRequest(")
        append("alias=$alias,")
        append("clientToken=$clientToken,")
        append("kmsKeyArn=$kmsKeyArn,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = alias?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateWorkspaceRequest

        if (alias != other.alias) return false
        if (clientToken != other.clientToken) return false
        if (kmsKeyArn != other.kmsKeyArn) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amp.model.CreateWorkspaceRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An alias that you assign to this workspace to help you identify it. It does not need to be unique.
         *
         * Blank spaces at the beginning or end of the alias that you specify will be trimmed from the value used.
         */
        public var alias: kotlin.String? = null
        /**
         * A unique identifier that you can provide to ensure the idempotency of the request. Case-sensitive.
         */
        public var clientToken: kotlin.String? = null
        /**
         * (optional) The ARN for a customer managed KMS key to use for encrypting data within your workspace. For more information about using your own key in your workspace, see [Encryption at rest](https://docs.aws.amazon.com/prometheus/latest/userguide/encryption-at-rest-Amazon-Service-Prometheus.html) in the *Amazon Managed Service for Prometheus User Guide*.
         */
        public var kmsKeyArn: kotlin.String? = null
        /**
         * The list of tag keys and values to associate with the workspace.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amp.model.CreateWorkspaceRequest) : this() {
            this.alias = x.alias
            this.clientToken = x.clientToken
            this.kmsKeyArn = x.kmsKeyArn
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amp.model.CreateWorkspaceRequest = CreateWorkspaceRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
