// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amp

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.amp.auth.AmpAuthSchemeProvider
import aws.sdk.kotlin.services.amp.auth.DefaultAmpAuthSchemeProvider
import aws.sdk.kotlin.services.amp.endpoints.AmpEndpointParameters
import aws.sdk.kotlin.services.amp.endpoints.AmpEndpointProvider
import aws.sdk.kotlin.services.amp.endpoints.DefaultAmpEndpointProvider
import aws.sdk.kotlin.services.amp.model.CreateAlertManagerDefinitionRequest
import aws.sdk.kotlin.services.amp.model.CreateAlertManagerDefinitionResponse
import aws.sdk.kotlin.services.amp.model.CreateLoggingConfigurationRequest
import aws.sdk.kotlin.services.amp.model.CreateLoggingConfigurationResponse
import aws.sdk.kotlin.services.amp.model.CreateRuleGroupsNamespaceRequest
import aws.sdk.kotlin.services.amp.model.CreateRuleGroupsNamespaceResponse
import aws.sdk.kotlin.services.amp.model.CreateScraperRequest
import aws.sdk.kotlin.services.amp.model.CreateScraperResponse
import aws.sdk.kotlin.services.amp.model.CreateWorkspaceRequest
import aws.sdk.kotlin.services.amp.model.CreateWorkspaceResponse
import aws.sdk.kotlin.services.amp.model.DeleteAlertManagerDefinitionRequest
import aws.sdk.kotlin.services.amp.model.DeleteAlertManagerDefinitionResponse
import aws.sdk.kotlin.services.amp.model.DeleteLoggingConfigurationRequest
import aws.sdk.kotlin.services.amp.model.DeleteLoggingConfigurationResponse
import aws.sdk.kotlin.services.amp.model.DeleteRuleGroupsNamespaceRequest
import aws.sdk.kotlin.services.amp.model.DeleteRuleGroupsNamespaceResponse
import aws.sdk.kotlin.services.amp.model.DeleteScraperRequest
import aws.sdk.kotlin.services.amp.model.DeleteScraperResponse
import aws.sdk.kotlin.services.amp.model.DeleteWorkspaceRequest
import aws.sdk.kotlin.services.amp.model.DeleteWorkspaceResponse
import aws.sdk.kotlin.services.amp.model.DescribeAlertManagerDefinitionRequest
import aws.sdk.kotlin.services.amp.model.DescribeAlertManagerDefinitionResponse
import aws.sdk.kotlin.services.amp.model.DescribeLoggingConfigurationRequest
import aws.sdk.kotlin.services.amp.model.DescribeLoggingConfigurationResponse
import aws.sdk.kotlin.services.amp.model.DescribeRuleGroupsNamespaceRequest
import aws.sdk.kotlin.services.amp.model.DescribeRuleGroupsNamespaceResponse
import aws.sdk.kotlin.services.amp.model.DescribeScraperRequest
import aws.sdk.kotlin.services.amp.model.DescribeScraperResponse
import aws.sdk.kotlin.services.amp.model.DescribeWorkspaceRequest
import aws.sdk.kotlin.services.amp.model.DescribeWorkspaceResponse
import aws.sdk.kotlin.services.amp.model.GetDefaultScraperConfigurationRequest
import aws.sdk.kotlin.services.amp.model.GetDefaultScraperConfigurationResponse
import aws.sdk.kotlin.services.amp.model.ListRuleGroupsNamespacesRequest
import aws.sdk.kotlin.services.amp.model.ListRuleGroupsNamespacesResponse
import aws.sdk.kotlin.services.amp.model.ListScrapersRequest
import aws.sdk.kotlin.services.amp.model.ListScrapersResponse
import aws.sdk.kotlin.services.amp.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.amp.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.amp.model.ListWorkspacesRequest
import aws.sdk.kotlin.services.amp.model.ListWorkspacesResponse
import aws.sdk.kotlin.services.amp.model.PutAlertManagerDefinitionRequest
import aws.sdk.kotlin.services.amp.model.PutAlertManagerDefinitionResponse
import aws.sdk.kotlin.services.amp.model.PutRuleGroupsNamespaceRequest
import aws.sdk.kotlin.services.amp.model.PutRuleGroupsNamespaceResponse
import aws.sdk.kotlin.services.amp.model.TagResourceRequest
import aws.sdk.kotlin.services.amp.model.TagResourceResponse
import aws.sdk.kotlin.services.amp.model.UntagResourceRequest
import aws.sdk.kotlin.services.amp.model.UntagResourceResponse
import aws.sdk.kotlin.services.amp.model.UpdateLoggingConfigurationRequest
import aws.sdk.kotlin.services.amp.model.UpdateLoggingConfigurationResponse
import aws.sdk.kotlin.services.amp.model.UpdateWorkspaceAliasRequest
import aws.sdk.kotlin.services.amp.model.UpdateWorkspaceAliasResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "amp"
public const val SdkVersion: String = "1.2.3"
public const val ServiceApiVersion: String = "2020-08-01"

/**
 * Amazon Managed Service for Prometheus is a serverless, Prometheus-compatible monitoring service for container metrics that makes it easier to securely monitor container environments at scale. With Amazon Managed Service for Prometheus, you can use the same open-source Prometheus data model and query language that you use today to monitor the performance of your containerized workloads, and also enjoy improved scalability, availability, and security without having to manage the underlying infrastructure.
 *
 * For more information about Amazon Managed Service for Prometheus, see the [Amazon Managed Service for Prometheus](https://docs.aws.amazon.com/prometheus/latest/userguide/what-is-Amazon-Managed-Service-Prometheus.html) User Guide.
 *
 * Amazon Managed Service for Prometheus includes two APIs.
 * + Use the Amazon Web Services API described in this guide to manage Amazon Managed Service for Prometheus resources, such as workspaces, rule groups, and alert managers.
 * + Use the [Prometheus-compatible API](https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-Prometheus-Compatible-Apis) to work within your Prometheus workspace.
 */
public interface AmpClient : SdkClient {
    /**
     * AmpClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, AmpClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Amp",
                "AMP",
                "amp",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, AmpClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): AmpClient = DefaultAmpClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: AmpEndpointProvider = builder.endpointProvider ?: DefaultAmpEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: AmpAuthSchemeProvider = builder.authSchemeProvider ?: DefaultAmpAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "amp"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: AmpEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: AmpAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * The `CreateAlertManagerDefinition` operation creates the alert manager definition in a workspace. If a workspace already has an alert manager definition, don't use this operation to update it. Instead, use `PutAlertManagerDefinition`.
     */
    public suspend fun createAlertManagerDefinition(input: CreateAlertManagerDefinitionRequest): CreateAlertManagerDefinitionResponse

    /**
     * The `CreateLoggingConfiguration` operation creates a logging configuration for the workspace. Use this operation to set the CloudWatch log group to which the logs will be published to.
     */
    public suspend fun createLoggingConfiguration(input: CreateLoggingConfigurationRequest): CreateLoggingConfigurationResponse

    /**
     * The `CreateRuleGroupsNamespace` operation creates a rule groups namespace within a workspace. A rule groups namespace is associated with exactly one rules file. A workspace can have multiple rule groups namespaces.
     *
     * Use this operation only to create new rule groups namespaces. To update an existing rule groups namespace, use `PutRuleGroupsNamespace`.
     */
    public suspend fun createRuleGroupsNamespace(input: CreateRuleGroupsNamespaceRequest): CreateRuleGroupsNamespaceResponse

    /**
     * The `CreateScraper` operation creates a scraper to collect metrics. A scraper pulls metrics from Prometheus-compatible sources within an Amazon EKS cluster, and sends them to your Amazon Managed Service for Prometheus workspace. You can configure the scraper to control what metrics are collected, and what transformations are applied prior to sending them to your workspace.
     *
     * If needed, an IAM role will be created for you that gives Amazon Managed Service for Prometheus access to the metrics in your cluster. For more information, see [Using roles for scraping metrics from EKS](https://docs.aws.amazon.com/prometheus/latest/userguide/using-service-linked-roles.html#using-service-linked-roles-prom-scraper) in the *Amazon Managed Service for Prometheus User Guide*.
     *
     * You cannot update a scraper. If you want to change the configuration of the scraper, create a new scraper and delete the old one.
     *
     * The `scrapeConfiguration` parameter contains the base64-encoded version of the YAML configuration file.
     *
     * For more information about collectors, including what metrics are collected, and how to configure the scraper, see [Amazon Web Services managed collectors](https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-collector.html) in the *Amazon Managed Service for Prometheus User Guide*.
     *
     * @sample aws.sdk.kotlin.services.amp.samples.CreateScraper.sample
     */
    public suspend fun createScraper(input: CreateScraperRequest): CreateScraperResponse

    /**
     * Creates a Prometheus workspace. A workspace is a logical space dedicated to the storage and querying of Prometheus metrics. You can have one or more workspaces in each Region in your account.
     */
    public suspend fun createWorkspace(input: CreateWorkspaceRequest = CreateWorkspaceRequest { }): CreateWorkspaceResponse

    /**
     * Deletes the alert manager definition from a workspace.
     */
    public suspend fun deleteAlertManagerDefinition(input: DeleteAlertManagerDefinitionRequest): DeleteAlertManagerDefinitionResponse

    /**
     * Deletes the logging configuration for a workspace.
     */
    public suspend fun deleteLoggingConfiguration(input: DeleteLoggingConfigurationRequest): DeleteLoggingConfigurationResponse

    /**
     * Deletes one rule groups namespace and its associated rule groups definition.
     */
    public suspend fun deleteRuleGroupsNamespace(input: DeleteRuleGroupsNamespaceRequest): DeleteRuleGroupsNamespaceResponse

    /**
     * The `DeleteScraper` operation deletes one scraper, and stops any metrics collection that the scraper performs.
     *
     * @sample aws.sdk.kotlin.services.amp.samples.DeleteScraper.sample
     */
    public suspend fun deleteScraper(input: DeleteScraperRequest): DeleteScraperResponse

    /**
     * Deletes an existing workspace.
     *
     * When you delete a workspace, the data that has been ingested into it is not immediately deleted. It will be permanently deleted within one month.
     */
    public suspend fun deleteWorkspace(input: DeleteWorkspaceRequest): DeleteWorkspaceResponse

    /**
     * Retrieves the full information about the alert manager definition for a workspace.
     */
    public suspend fun describeAlertManagerDefinition(input: DescribeAlertManagerDefinitionRequest): DescribeAlertManagerDefinitionResponse

    /**
     * Returns complete information about the current logging configuration of the workspace.
     */
    public suspend fun describeLoggingConfiguration(input: DescribeLoggingConfigurationRequest): DescribeLoggingConfigurationResponse

    /**
     * Returns complete information about one rule groups namespace. To retrieve a list of rule groups namespaces, use `ListRuleGroupsNamespaces`.
     */
    public suspend fun describeRuleGroupsNamespace(input: DescribeRuleGroupsNamespaceRequest): DescribeRuleGroupsNamespaceResponse

    /**
     * The `DescribeScraper` operation displays information about an existing scraper.
     *
     * @sample aws.sdk.kotlin.services.amp.samples.DescribeScraper.sample
     */
    public suspend fun describeScraper(input: DescribeScraperRequest): DescribeScraperResponse

    /**
     * Returns information about an existing workspace.
     */
    public suspend fun describeWorkspace(input: DescribeWorkspaceRequest): DescribeWorkspaceResponse

    /**
     * The `GetDefaultScraperConfiguration` operation returns the default scraper configuration used when Amazon EKS creates a scraper for you.
     *
     * @sample aws.sdk.kotlin.services.amp.samples.GetDefaultScraperConfiguration.sample
     */
    public suspend fun getDefaultScraperConfiguration(input: GetDefaultScraperConfigurationRequest = GetDefaultScraperConfigurationRequest { }): GetDefaultScraperConfigurationResponse

    /**
     * Returns a list of rule groups namespaces in a workspace.
     */
    public suspend fun listRuleGroupsNamespaces(input: ListRuleGroupsNamespacesRequest): ListRuleGroupsNamespacesResponse

    /**
     * The `ListScrapers` operation lists all of the scrapers in your account. This includes scrapers being created or deleted. You can optionally filter the returned list.
     *
     * @sample aws.sdk.kotlin.services.amp.samples.ListScrapers.sample
     * @sample aws.sdk.kotlin.services.amp.samples.ListScrapers.sample2
     */
    public suspend fun listScrapers(input: ListScrapersRequest = ListScrapersRequest { }): ListScrapersResponse

    /**
     * The `ListTagsForResource` operation returns the tags that are associated with an Amazon Managed Service for Prometheus resource. Currently, the only resources that can be tagged are workspaces and rule groups namespaces.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists all of the Amazon Managed Service for Prometheus workspaces in your account. This includes workspaces being created or deleted.
     */
    public suspend fun listWorkspaces(input: ListWorkspacesRequest = ListWorkspacesRequest { }): ListWorkspacesResponse

    /**
     * Updates an existing alert manager definition in a workspace. If the workspace does not already have an alert manager definition, don't use this operation to create it. Instead, use `CreateAlertManagerDefinition`.
     */
    public suspend fun putAlertManagerDefinition(input: PutAlertManagerDefinitionRequest): PutAlertManagerDefinitionResponse

    /**
     * Updates an existing rule groups namespace within a workspace. A rule groups namespace is associated with exactly one rules file. A workspace can have multiple rule groups namespaces.
     *
     * Use this operation only to update existing rule groups namespaces. To create a new rule groups namespace, use `CreateRuleGroupsNamespace`.
     *
     * You can't use this operation to add tags to an existing rule groups namespace. Instead, use `TagResource`.
     */
    public suspend fun putRuleGroupsNamespace(input: PutRuleGroupsNamespaceRequest): PutRuleGroupsNamespaceResponse

    /**
     * The `TagResource` operation associates tags with an Amazon Managed Service for Prometheus resource. The only resources that can be tagged are workspaces and rule groups namespaces.
     *
     * If you specify a new tag key for the resource, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces the previous value for that tag.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes the specified tags from an Amazon Managed Service for Prometheus resource. The only resources that can be tagged are workspaces and rule groups namespaces.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the log group ARN or the workspace ID of the current logging configuration.
     */
    public suspend fun updateLoggingConfiguration(input: UpdateLoggingConfigurationRequest): UpdateLoggingConfigurationResponse

    /**
     * Updates the alias of an existing workspace.
     */
    public suspend fun updateWorkspaceAlias(input: UpdateWorkspaceAliasRequest): UpdateWorkspaceAliasResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun AmpClient.withConfig(block: AmpClient.Config.Builder.() -> Unit): AmpClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultAmpClient(newConfig)
}

/**
 * The `CreateAlertManagerDefinition` operation creates the alert manager definition in a workspace. If a workspace already has an alert manager definition, don't use this operation to update it. Instead, use `PutAlertManagerDefinition`.
 */
public suspend inline fun AmpClient.createAlertManagerDefinition(crossinline block: CreateAlertManagerDefinitionRequest.Builder.() -> Unit): CreateAlertManagerDefinitionResponse = createAlertManagerDefinition(CreateAlertManagerDefinitionRequest.Builder().apply(block).build())

/**
 * The `CreateLoggingConfiguration` operation creates a logging configuration for the workspace. Use this operation to set the CloudWatch log group to which the logs will be published to.
 */
public suspend inline fun AmpClient.createLoggingConfiguration(crossinline block: CreateLoggingConfigurationRequest.Builder.() -> Unit): CreateLoggingConfigurationResponse = createLoggingConfiguration(CreateLoggingConfigurationRequest.Builder().apply(block).build())

/**
 * The `CreateRuleGroupsNamespace` operation creates a rule groups namespace within a workspace. A rule groups namespace is associated with exactly one rules file. A workspace can have multiple rule groups namespaces.
 *
 * Use this operation only to create new rule groups namespaces. To update an existing rule groups namespace, use `PutRuleGroupsNamespace`.
 */
public suspend inline fun AmpClient.createRuleGroupsNamespace(crossinline block: CreateRuleGroupsNamespaceRequest.Builder.() -> Unit): CreateRuleGroupsNamespaceResponse = createRuleGroupsNamespace(CreateRuleGroupsNamespaceRequest.Builder().apply(block).build())

/**
 * The `CreateScraper` operation creates a scraper to collect metrics. A scraper pulls metrics from Prometheus-compatible sources within an Amazon EKS cluster, and sends them to your Amazon Managed Service for Prometheus workspace. You can configure the scraper to control what metrics are collected, and what transformations are applied prior to sending them to your workspace.
 *
 * If needed, an IAM role will be created for you that gives Amazon Managed Service for Prometheus access to the metrics in your cluster. For more information, see [Using roles for scraping metrics from EKS](https://docs.aws.amazon.com/prometheus/latest/userguide/using-service-linked-roles.html#using-service-linked-roles-prom-scraper) in the *Amazon Managed Service for Prometheus User Guide*.
 *
 * You cannot update a scraper. If you want to change the configuration of the scraper, create a new scraper and delete the old one.
 *
 * The `scrapeConfiguration` parameter contains the base64-encoded version of the YAML configuration file.
 *
 * For more information about collectors, including what metrics are collected, and how to configure the scraper, see [Amazon Web Services managed collectors](https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-collector.html) in the *Amazon Managed Service for Prometheus User Guide*.
 *
 * @sample aws.sdk.kotlin.services.amp.samples.CreateScraper.sample
 */
public suspend inline fun AmpClient.createScraper(crossinline block: CreateScraperRequest.Builder.() -> Unit): CreateScraperResponse = createScraper(CreateScraperRequest.Builder().apply(block).build())

/**
 * Creates a Prometheus workspace. A workspace is a logical space dedicated to the storage and querying of Prometheus metrics. You can have one or more workspaces in each Region in your account.
 */
public suspend inline fun AmpClient.createWorkspace(crossinline block: CreateWorkspaceRequest.Builder.() -> Unit): CreateWorkspaceResponse = createWorkspace(CreateWorkspaceRequest.Builder().apply(block).build())

/**
 * Deletes the alert manager definition from a workspace.
 */
public suspend inline fun AmpClient.deleteAlertManagerDefinition(crossinline block: DeleteAlertManagerDefinitionRequest.Builder.() -> Unit): DeleteAlertManagerDefinitionResponse = deleteAlertManagerDefinition(DeleteAlertManagerDefinitionRequest.Builder().apply(block).build())

/**
 * Deletes the logging configuration for a workspace.
 */
public suspend inline fun AmpClient.deleteLoggingConfiguration(crossinline block: DeleteLoggingConfigurationRequest.Builder.() -> Unit): DeleteLoggingConfigurationResponse = deleteLoggingConfiguration(DeleteLoggingConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes one rule groups namespace and its associated rule groups definition.
 */
public suspend inline fun AmpClient.deleteRuleGroupsNamespace(crossinline block: DeleteRuleGroupsNamespaceRequest.Builder.() -> Unit): DeleteRuleGroupsNamespaceResponse = deleteRuleGroupsNamespace(DeleteRuleGroupsNamespaceRequest.Builder().apply(block).build())

/**
 * The `DeleteScraper` operation deletes one scraper, and stops any metrics collection that the scraper performs.
 *
 * @sample aws.sdk.kotlin.services.amp.samples.DeleteScraper.sample
 */
public suspend inline fun AmpClient.deleteScraper(crossinline block: DeleteScraperRequest.Builder.() -> Unit): DeleteScraperResponse = deleteScraper(DeleteScraperRequest.Builder().apply(block).build())

/**
 * Deletes an existing workspace.
 *
 * When you delete a workspace, the data that has been ingested into it is not immediately deleted. It will be permanently deleted within one month.
 */
public suspend inline fun AmpClient.deleteWorkspace(crossinline block: DeleteWorkspaceRequest.Builder.() -> Unit): DeleteWorkspaceResponse = deleteWorkspace(DeleteWorkspaceRequest.Builder().apply(block).build())

/**
 * Retrieves the full information about the alert manager definition for a workspace.
 */
public suspend inline fun AmpClient.describeAlertManagerDefinition(crossinline block: DescribeAlertManagerDefinitionRequest.Builder.() -> Unit): DescribeAlertManagerDefinitionResponse = describeAlertManagerDefinition(DescribeAlertManagerDefinitionRequest.Builder().apply(block).build())

/**
 * Returns complete information about the current logging configuration of the workspace.
 */
public suspend inline fun AmpClient.describeLoggingConfiguration(crossinline block: DescribeLoggingConfigurationRequest.Builder.() -> Unit): DescribeLoggingConfigurationResponse = describeLoggingConfiguration(DescribeLoggingConfigurationRequest.Builder().apply(block).build())

/**
 * Returns complete information about one rule groups namespace. To retrieve a list of rule groups namespaces, use `ListRuleGroupsNamespaces`.
 */
public suspend inline fun AmpClient.describeRuleGroupsNamespace(crossinline block: DescribeRuleGroupsNamespaceRequest.Builder.() -> Unit): DescribeRuleGroupsNamespaceResponse = describeRuleGroupsNamespace(DescribeRuleGroupsNamespaceRequest.Builder().apply(block).build())

/**
 * The `DescribeScraper` operation displays information about an existing scraper.
 *
 * @sample aws.sdk.kotlin.services.amp.samples.DescribeScraper.sample
 */
public suspend inline fun AmpClient.describeScraper(crossinline block: DescribeScraperRequest.Builder.() -> Unit): DescribeScraperResponse = describeScraper(DescribeScraperRequest.Builder().apply(block).build())

/**
 * Returns information about an existing workspace.
 */
public suspend inline fun AmpClient.describeWorkspace(crossinline block: DescribeWorkspaceRequest.Builder.() -> Unit): DescribeWorkspaceResponse = describeWorkspace(DescribeWorkspaceRequest.Builder().apply(block).build())

/**
 * The `GetDefaultScraperConfiguration` operation returns the default scraper configuration used when Amazon EKS creates a scraper for you.
 *
 * @sample aws.sdk.kotlin.services.amp.samples.GetDefaultScraperConfiguration.sample
 */
public suspend inline fun AmpClient.getDefaultScraperConfiguration(crossinline block: GetDefaultScraperConfigurationRequest.Builder.() -> Unit): GetDefaultScraperConfigurationResponse = getDefaultScraperConfiguration(GetDefaultScraperConfigurationRequest.Builder().apply(block).build())

/**
 * Returns a list of rule groups namespaces in a workspace.
 */
public suspend inline fun AmpClient.listRuleGroupsNamespaces(crossinline block: ListRuleGroupsNamespacesRequest.Builder.() -> Unit): ListRuleGroupsNamespacesResponse = listRuleGroupsNamespaces(ListRuleGroupsNamespacesRequest.Builder().apply(block).build())

/**
 * The `ListScrapers` operation lists all of the scrapers in your account. This includes scrapers being created or deleted. You can optionally filter the returned list.
 *
 * @sample aws.sdk.kotlin.services.amp.samples.ListScrapers.sample
 * @sample aws.sdk.kotlin.services.amp.samples.ListScrapers.sample2
 */
public suspend inline fun AmpClient.listScrapers(crossinline block: ListScrapersRequest.Builder.() -> Unit): ListScrapersResponse = listScrapers(ListScrapersRequest.Builder().apply(block).build())

/**
 * The `ListTagsForResource` operation returns the tags that are associated with an Amazon Managed Service for Prometheus resource. Currently, the only resources that can be tagged are workspaces and rule groups namespaces.
 */
public suspend inline fun AmpClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists all of the Amazon Managed Service for Prometheus workspaces in your account. This includes workspaces being created or deleted.
 */
public suspend inline fun AmpClient.listWorkspaces(crossinline block: ListWorkspacesRequest.Builder.() -> Unit): ListWorkspacesResponse = listWorkspaces(ListWorkspacesRequest.Builder().apply(block).build())

/**
 * Updates an existing alert manager definition in a workspace. If the workspace does not already have an alert manager definition, don't use this operation to create it. Instead, use `CreateAlertManagerDefinition`.
 */
public suspend inline fun AmpClient.putAlertManagerDefinition(crossinline block: PutAlertManagerDefinitionRequest.Builder.() -> Unit): PutAlertManagerDefinitionResponse = putAlertManagerDefinition(PutAlertManagerDefinitionRequest.Builder().apply(block).build())

/**
 * Updates an existing rule groups namespace within a workspace. A rule groups namespace is associated with exactly one rules file. A workspace can have multiple rule groups namespaces.
 *
 * Use this operation only to update existing rule groups namespaces. To create a new rule groups namespace, use `CreateRuleGroupsNamespace`.
 *
 * You can't use this operation to add tags to an existing rule groups namespace. Instead, use `TagResource`.
 */
public suspend inline fun AmpClient.putRuleGroupsNamespace(crossinline block: PutRuleGroupsNamespaceRequest.Builder.() -> Unit): PutRuleGroupsNamespaceResponse = putRuleGroupsNamespace(PutRuleGroupsNamespaceRequest.Builder().apply(block).build())

/**
 * The `TagResource` operation associates tags with an Amazon Managed Service for Prometheus resource. The only resources that can be tagged are workspaces and rule groups namespaces.
 *
 * If you specify a new tag key for the resource, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces the previous value for that tag.
 */
public suspend inline fun AmpClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes the specified tags from an Amazon Managed Service for Prometheus resource. The only resources that can be tagged are workspaces and rule groups namespaces.
 */
public suspend inline fun AmpClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the log group ARN or the workspace ID of the current logging configuration.
 */
public suspend inline fun AmpClient.updateLoggingConfiguration(crossinline block: UpdateLoggingConfigurationRequest.Builder.() -> Unit): UpdateLoggingConfigurationResponse = updateLoggingConfiguration(UpdateLoggingConfigurationRequest.Builder().apply(block).build())

/**
 * Updates the alias of an existing workspace.
 */
public suspend inline fun AmpClient.updateWorkspaceAlias(crossinline block: UpdateWorkspaceAliasRequest.Builder.() -> Unit): UpdateWorkspaceAliasResponse = updateWorkspaceAlias(UpdateWorkspaceAliasRequest.Builder().apply(block).build())
