// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amp.serde

import aws.sdk.kotlin.services.amp.model.AmpException
import aws.sdk.kotlin.services.amp.model.ListRuleGroupsNamespacesResponse
import aws.sdk.kotlin.services.amp.model.RuleGroupsNamespaceSummary
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListRuleGroupsNamespacesOperationDeserializer: HttpDeserialize<ListRuleGroupsNamespacesResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): ListRuleGroupsNamespacesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListRuleGroupsNamespacesError(context, call)
        }
        val builder = ListRuleGroupsNamespacesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListRuleGroupsNamespacesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwListRuleGroupsNamespacesError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw AmpException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        else -> AmpException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListRuleGroupsNamespacesOperationBody(builder: ListRuleGroupsNamespacesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val RULEGROUPSNAMESPACES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ruleGroupsNamespaces"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTTOKEN_DESCRIPTOR)
        field(RULEGROUPSNAMESPACES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                RULEGROUPSNAMESPACES_DESCRIPTOR.index -> builder.ruleGroupsNamespaces =
                    deserializer.deserializeList(RULEGROUPSNAMESPACES_DESCRIPTOR) {
                        val col0 = mutableListOf<RuleGroupsNamespaceSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeRuleGroupsNamespaceSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
