// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amp.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents the properties of a workspace.
 */
public class WorkspaceDescription private constructor(builder: Builder) {
    /**
     * Alias of this workspace.
     */
    public val alias: kotlin.String? = builder.alias
    /**
     * The Amazon Resource Name (ARN) of this workspace.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The time when the workspace was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * Prometheus endpoint URI.
     */
    public val prometheusEndpoint: kotlin.String? = builder.prometheusEndpoint
    /**
     * The status of this workspace.
     */
    public val status: aws.sdk.kotlin.services.amp.model.WorkspaceStatus? = builder.status
    /**
     * The tags of this workspace.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * Unique string identifying this workspace.
     */
    public val workspaceId: kotlin.String = requireNotNull(builder.workspaceId) { "A non-null value must be provided for workspaceId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amp.model.WorkspaceDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WorkspaceDescription(")
        append("alias=$alias,")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("prometheusEndpoint=$prometheusEndpoint,")
        append("status=$status,")
        append("tags=$tags,")
        append("workspaceId=$workspaceId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = alias?.hashCode() ?: 0
        result = 31 * result + (arn.hashCode())
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (prometheusEndpoint?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (workspaceId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WorkspaceDescription

        if (alias != other.alias) return false
        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (prometheusEndpoint != other.prometheusEndpoint) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (workspaceId != other.workspaceId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amp.model.WorkspaceDescription = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Alias of this workspace.
         */
        public var alias: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of this workspace.
         */
        public var arn: kotlin.String? = null
        /**
         * The time when the workspace was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Prometheus endpoint URI.
         */
        public var prometheusEndpoint: kotlin.String? = null
        /**
         * The status of this workspace.
         */
        public var status: aws.sdk.kotlin.services.amp.model.WorkspaceStatus? = null
        /**
         * The tags of this workspace.
         */
        public var tags: Map<String, String>? = null
        /**
         * Unique string identifying this workspace.
         */
        public var workspaceId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amp.model.WorkspaceDescription) : this() {
            this.alias = x.alias
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.prometheusEndpoint = x.prometheusEndpoint
            this.status = x.status
            this.tags = x.tags
            this.workspaceId = x.workspaceId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amp.model.WorkspaceDescription = WorkspaceDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.amp.model.WorkspaceStatus] inside the given [block]
         */
        public fun status(block: aws.sdk.kotlin.services.amp.model.WorkspaceStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.amp.model.WorkspaceStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (workspaceId == null) workspaceId = ""
            return this
        }
    }
}
