// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amp.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents the properties of a logging configuration metadata.
 */
public class LoggingConfigurationMetadata private constructor(builder: Builder) {
    /**
     * The time when the logging configuration was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The ARN of the CW log group to which the vended log data will be published.
     */
    public val logGroupArn: kotlin.String = requireNotNull(builder.logGroupArn) { "A non-null value must be provided for logGroupArn" }
    /**
     * The time when the logging configuration was modified.
     */
    public val modifiedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.modifiedAt) { "A non-null value must be provided for modifiedAt" }
    /**
     * The status of the logging configuration.
     */
    public val status: aws.sdk.kotlin.services.amp.model.LoggingConfigurationStatus? = builder.status
    /**
     * The workspace where the logging configuration exists.
     */
    public val workspace: kotlin.String = requireNotNull(builder.workspace) { "A non-null value must be provided for workspace" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amp.model.LoggingConfigurationMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LoggingConfigurationMetadata(")
        append("createdAt=$createdAt,")
        append("logGroupArn=$logGroupArn,")
        append("modifiedAt=$modifiedAt,")
        append("status=$status,")
        append("workspace=$workspace")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt.hashCode()
        result = 31 * result + (logGroupArn.hashCode())
        result = 31 * result + (modifiedAt.hashCode())
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (workspace.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LoggingConfigurationMetadata

        if (createdAt != other.createdAt) return false
        if (logGroupArn != other.logGroupArn) return false
        if (modifiedAt != other.modifiedAt) return false
        if (status != other.status) return false
        if (workspace != other.workspace) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amp.model.LoggingConfigurationMetadata = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The time when the logging configuration was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN of the CW log group to which the vended log data will be published.
         */
        public var logGroupArn: kotlin.String? = null
        /**
         * The time when the logging configuration was modified.
         */
        public var modifiedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the logging configuration.
         */
        public var status: aws.sdk.kotlin.services.amp.model.LoggingConfigurationStatus? = null
        /**
         * The workspace where the logging configuration exists.
         */
        public var workspace: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amp.model.LoggingConfigurationMetadata) : this() {
            this.createdAt = x.createdAt
            this.logGroupArn = x.logGroupArn
            this.modifiedAt = x.modifiedAt
            this.status = x.status
            this.workspace = x.workspace
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amp.model.LoggingConfigurationMetadata = LoggingConfigurationMetadata(this)

        /**
         * construct an [aws.sdk.kotlin.services.amp.model.LoggingConfigurationStatus] inside the given [block]
         */
        public fun status(block: aws.sdk.kotlin.services.amp.model.LoggingConfigurationStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.amp.model.LoggingConfigurationStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (logGroupArn == null) logGroupArn = ""
            if (modifiedAt == null) modifiedAt = Instant.fromEpochSeconds(0)
            if (workspace == null) workspace = ""
            return this
        }
    }
}
