// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amp.model



/**
 * Represents the input of a CreateRuleGroupsNamespace operation.
 */
public class CreateRuleGroupsNamespaceRequest private constructor(builder: Builder) {
    /**
     * Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The namespace data that define the rule groups.
     */
    public val data: kotlin.ByteArray = requireNotNull(builder.data) { "A non-null value must be provided for data" }
    /**
     * The rule groups namespace name.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Optional, user-provided tags for this rule groups namespace.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The ID of the workspace in which to create the rule group namespace.
     */
    public val workspaceId: kotlin.String = requireNotNull(builder.workspaceId) { "A non-null value must be provided for workspaceId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amp.model.CreateRuleGroupsNamespaceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateRuleGroupsNamespaceRequest(")
        append("clientToken=$clientToken,")
        append("data=$data,")
        append("name=$name,")
        append("tags=$tags,")
        append("workspaceId=$workspaceId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (data.contentHashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (workspaceId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateRuleGroupsNamespaceRequest

        if (clientToken != other.clientToken) return false
        if (data != null) {
            if (other.data == null) return false
            if (!data.contentEquals(other.data)) return false
        } else if (other.data != null) return false
        if (name != other.name) return false
        if (tags != other.tags) return false
        if (workspaceId != other.workspaceId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amp.model.CreateRuleGroupsNamespaceRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The namespace data that define the rule groups.
         */
        public var data: kotlin.ByteArray? = null
        /**
         * The rule groups namespace name.
         */
        public var name: kotlin.String? = null
        /**
         * Optional, user-provided tags for this rule groups namespace.
         */
        public var tags: Map<String, String>? = null
        /**
         * The ID of the workspace in which to create the rule group namespace.
         */
        public var workspaceId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amp.model.CreateRuleGroupsNamespaceRequest) : this() {
            this.clientToken = x.clientToken
            this.data = x.data
            this.name = x.name
            this.tags = x.tags
            this.workspaceId = x.workspaceId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amp.model.CreateRuleGroupsNamespaceRequest = CreateRuleGroupsNamespaceRequest(this)

        internal fun correctErrors(): Builder {
            if (data == null) data = ByteArray(0)
            if (name == null) name = ""
            if (workspaceId == null) workspaceId = ""
            return this
        }
    }
}
