// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amp.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents the properties of an alert manager definition.
 */
public class AlertManagerDefinitionDescription private constructor(builder: Builder) {
    /**
     * The time when the alert manager definition was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The alert manager definition.
     */
    public val data: kotlin.ByteArray = requireNotNull(builder.data) { "A non-null value must be provided for data" }
    /**
     * The time when the alert manager definition was modified.
     */
    public val modifiedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.modifiedAt) { "A non-null value must be provided for modifiedAt" }
    /**
     * The status of alert manager definition.
     */
    public val status: aws.sdk.kotlin.services.amp.model.AlertManagerDefinitionStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amp.model.AlertManagerDefinitionDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AlertManagerDefinitionDescription(")
        append("createdAt=$createdAt,")
        append("data=$data,")
        append("modifiedAt=$modifiedAt,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt.hashCode()
        result = 31 * result + (data.contentHashCode())
        result = 31 * result + (modifiedAt.hashCode())
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AlertManagerDefinitionDescription

        if (createdAt != other.createdAt) return false
        if (data != null) {
            if (other.data == null) return false
            if (!data.contentEquals(other.data)) return false
        } else if (other.data != null) return false
        if (modifiedAt != other.modifiedAt) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amp.model.AlertManagerDefinitionDescription = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The time when the alert manager definition was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The alert manager definition.
         */
        public var data: kotlin.ByteArray? = null
        /**
         * The time when the alert manager definition was modified.
         */
        public var modifiedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of alert manager definition.
         */
        public var status: aws.sdk.kotlin.services.amp.model.AlertManagerDefinitionStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amp.model.AlertManagerDefinitionDescription) : this() {
            this.createdAt = x.createdAt
            this.data = x.data
            this.modifiedAt = x.modifiedAt
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amp.model.AlertManagerDefinitionDescription = AlertManagerDefinitionDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.amp.model.AlertManagerDefinitionStatus] inside the given [block]
         */
        public fun status(block: aws.sdk.kotlin.services.amp.model.AlertManagerDefinitionStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.amp.model.AlertManagerDefinitionStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (data == null) data = ByteArray(0)
            if (modifiedAt == null) modifiedAt = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
