// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amp

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.amp.auth.AmpAuthSchemeProvider
import aws.sdk.kotlin.services.amp.auth.DefaultAmpAuthSchemeProvider
import aws.sdk.kotlin.services.amp.endpoints.AmpEndpointParameters
import aws.sdk.kotlin.services.amp.endpoints.AmpEndpointProvider
import aws.sdk.kotlin.services.amp.endpoints.DefaultAmpEndpointProvider
import aws.sdk.kotlin.services.amp.model.CreateAlertManagerDefinitionRequest
import aws.sdk.kotlin.services.amp.model.CreateAlertManagerDefinitionResponse
import aws.sdk.kotlin.services.amp.model.CreateLoggingConfigurationRequest
import aws.sdk.kotlin.services.amp.model.CreateLoggingConfigurationResponse
import aws.sdk.kotlin.services.amp.model.CreateRuleGroupsNamespaceRequest
import aws.sdk.kotlin.services.amp.model.CreateRuleGroupsNamespaceResponse
import aws.sdk.kotlin.services.amp.model.CreateWorkspaceRequest
import aws.sdk.kotlin.services.amp.model.CreateWorkspaceResponse
import aws.sdk.kotlin.services.amp.model.DeleteAlertManagerDefinitionRequest
import aws.sdk.kotlin.services.amp.model.DeleteAlertManagerDefinitionResponse
import aws.sdk.kotlin.services.amp.model.DeleteLoggingConfigurationRequest
import aws.sdk.kotlin.services.amp.model.DeleteLoggingConfigurationResponse
import aws.sdk.kotlin.services.amp.model.DeleteRuleGroupsNamespaceRequest
import aws.sdk.kotlin.services.amp.model.DeleteRuleGroupsNamespaceResponse
import aws.sdk.kotlin.services.amp.model.DeleteWorkspaceRequest
import aws.sdk.kotlin.services.amp.model.DeleteWorkspaceResponse
import aws.sdk.kotlin.services.amp.model.DescribeAlertManagerDefinitionRequest
import aws.sdk.kotlin.services.amp.model.DescribeAlertManagerDefinitionResponse
import aws.sdk.kotlin.services.amp.model.DescribeLoggingConfigurationRequest
import aws.sdk.kotlin.services.amp.model.DescribeLoggingConfigurationResponse
import aws.sdk.kotlin.services.amp.model.DescribeRuleGroupsNamespaceRequest
import aws.sdk.kotlin.services.amp.model.DescribeRuleGroupsNamespaceResponse
import aws.sdk.kotlin.services.amp.model.DescribeWorkspaceRequest
import aws.sdk.kotlin.services.amp.model.DescribeWorkspaceResponse
import aws.sdk.kotlin.services.amp.model.ListRuleGroupsNamespacesRequest
import aws.sdk.kotlin.services.amp.model.ListRuleGroupsNamespacesResponse
import aws.sdk.kotlin.services.amp.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.amp.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.amp.model.ListWorkspacesRequest
import aws.sdk.kotlin.services.amp.model.ListWorkspacesResponse
import aws.sdk.kotlin.services.amp.model.PutAlertManagerDefinitionRequest
import aws.sdk.kotlin.services.amp.model.PutAlertManagerDefinitionResponse
import aws.sdk.kotlin.services.amp.model.PutRuleGroupsNamespaceRequest
import aws.sdk.kotlin.services.amp.model.PutRuleGroupsNamespaceResponse
import aws.sdk.kotlin.services.amp.model.TagResourceRequest
import aws.sdk.kotlin.services.amp.model.TagResourceResponse
import aws.sdk.kotlin.services.amp.model.UntagResourceRequest
import aws.sdk.kotlin.services.amp.model.UntagResourceResponse
import aws.sdk.kotlin.services.amp.model.UpdateLoggingConfigurationRequest
import aws.sdk.kotlin.services.amp.model.UpdateLoggingConfigurationResponse
import aws.sdk.kotlin.services.amp.model.UpdateWorkspaceAliasRequest
import aws.sdk.kotlin.services.amp.model.UpdateWorkspaceAliasResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "amp"
public const val SdkVersion: String = "0.34.0-beta"

/**
 * Amazon Managed Service for Prometheus
 */
public interface AmpClient : SdkClient {
    /**
     * AmpClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, AmpClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>) {
            builder.config.interceptors.add(0, ClockSkewInterceptor())
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Amp",
                "AMP",
                "amp",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, AmpClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): AmpClient = DefaultAmpClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        public val authSchemeProvider: AmpAuthSchemeProvider = builder.authSchemeProvider ?: DefaultAmpAuthSchemeProvider
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: AmpEndpointProvider = builder.endpointProvider ?: DefaultAmpEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsDefaultRetryPolicy
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemeProvider = this@Config.authSchemeProvider
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "amp"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: AmpAuthSchemeProvider? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: AmpEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Create an alert manager definition.
     */
    public suspend fun createAlertManagerDefinition(input: CreateAlertManagerDefinitionRequest): CreateAlertManagerDefinitionResponse

    /**
     * Create logging configuration.
     */
    public suspend fun createLoggingConfiguration(input: CreateLoggingConfigurationRequest): CreateLoggingConfigurationResponse

    /**
     * Create a rule group namespace.
     */
    public suspend fun createRuleGroupsNamespace(input: CreateRuleGroupsNamespaceRequest): CreateRuleGroupsNamespaceResponse

    /**
     * Creates a new AMP workspace.
     */
    public suspend fun createWorkspace(input: CreateWorkspaceRequest = CreateWorkspaceRequest { }): CreateWorkspaceResponse

    /**
     * Deletes an alert manager definition.
     */
    public suspend fun deleteAlertManagerDefinition(input: DeleteAlertManagerDefinitionRequest): DeleteAlertManagerDefinitionResponse

    /**
     * Delete logging configuration.
     */
    public suspend fun deleteLoggingConfiguration(input: DeleteLoggingConfigurationRequest): DeleteLoggingConfigurationResponse

    /**
     * Delete a rule groups namespace.
     */
    public suspend fun deleteRuleGroupsNamespace(input: DeleteRuleGroupsNamespaceRequest): DeleteRuleGroupsNamespaceResponse

    /**
     * Deletes an AMP workspace.
     */
    public suspend fun deleteWorkspace(input: DeleteWorkspaceRequest): DeleteWorkspaceResponse

    /**
     * Describes an alert manager definition.
     */
    public suspend fun describeAlertManagerDefinition(input: DescribeAlertManagerDefinitionRequest): DescribeAlertManagerDefinitionResponse

    /**
     * Describes logging configuration.
     */
    public suspend fun describeLoggingConfiguration(input: DescribeLoggingConfigurationRequest): DescribeLoggingConfigurationResponse

    /**
     * Describe a rule groups namespace.
     */
    public suspend fun describeRuleGroupsNamespace(input: DescribeRuleGroupsNamespaceRequest): DescribeRuleGroupsNamespaceResponse

    /**
     * Describes an existing AMP workspace.
     */
    public suspend fun describeWorkspace(input: DescribeWorkspaceRequest): DescribeWorkspaceResponse

    /**
     * Lists rule groups namespaces.
     */
    public suspend fun listRuleGroupsNamespaces(input: ListRuleGroupsNamespacesRequest): ListRuleGroupsNamespacesResponse

    /**
     * Lists the tags you have assigned to the resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists all AMP workspaces, including workspaces being created or deleted.
     */
    public suspend fun listWorkspaces(input: ListWorkspacesRequest = ListWorkspacesRequest { }): ListWorkspacesResponse

    /**
     * Update an alert manager definition.
     */
    public suspend fun putAlertManagerDefinition(input: PutAlertManagerDefinitionRequest): PutAlertManagerDefinitionResponse

    /**
     * Update a rule groups namespace.
     */
    public suspend fun putRuleGroupsNamespace(input: PutRuleGroupsNamespaceRequest): PutRuleGroupsNamespaceResponse

    /**
     * Creates tags for the specified resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Deletes tags from the specified resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Update logging configuration.
     */
    public suspend fun updateLoggingConfiguration(input: UpdateLoggingConfigurationRequest): UpdateLoggingConfigurationResponse

    /**
     * Updates an AMP workspace alias.
     */
    public suspend fun updateWorkspaceAlias(input: UpdateWorkspaceAliasRequest): UpdateWorkspaceAliasResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun AmpClient.withConfig(block: AmpClient.Config.Builder.() -> Unit): AmpClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultAmpClient(newConfig)
}

/**
 * Create an alert manager definition.
 */
public suspend inline fun AmpClient.createAlertManagerDefinition(crossinline block: CreateAlertManagerDefinitionRequest.Builder.() -> Unit): CreateAlertManagerDefinitionResponse = createAlertManagerDefinition(CreateAlertManagerDefinitionRequest.Builder().apply(block).build())

/**
 * Create logging configuration.
 */
public suspend inline fun AmpClient.createLoggingConfiguration(crossinline block: CreateLoggingConfigurationRequest.Builder.() -> Unit): CreateLoggingConfigurationResponse = createLoggingConfiguration(CreateLoggingConfigurationRequest.Builder().apply(block).build())

/**
 * Create a rule group namespace.
 */
public suspend inline fun AmpClient.createRuleGroupsNamespace(crossinline block: CreateRuleGroupsNamespaceRequest.Builder.() -> Unit): CreateRuleGroupsNamespaceResponse = createRuleGroupsNamespace(CreateRuleGroupsNamespaceRequest.Builder().apply(block).build())

/**
 * Creates a new AMP workspace.
 */
public suspend inline fun AmpClient.createWorkspace(crossinline block: CreateWorkspaceRequest.Builder.() -> Unit): CreateWorkspaceResponse = createWorkspace(CreateWorkspaceRequest.Builder().apply(block).build())

/**
 * Deletes an alert manager definition.
 */
public suspend inline fun AmpClient.deleteAlertManagerDefinition(crossinline block: DeleteAlertManagerDefinitionRequest.Builder.() -> Unit): DeleteAlertManagerDefinitionResponse = deleteAlertManagerDefinition(DeleteAlertManagerDefinitionRequest.Builder().apply(block).build())

/**
 * Delete logging configuration.
 */
public suspend inline fun AmpClient.deleteLoggingConfiguration(crossinline block: DeleteLoggingConfigurationRequest.Builder.() -> Unit): DeleteLoggingConfigurationResponse = deleteLoggingConfiguration(DeleteLoggingConfigurationRequest.Builder().apply(block).build())

/**
 * Delete a rule groups namespace.
 */
public suspend inline fun AmpClient.deleteRuleGroupsNamespace(crossinline block: DeleteRuleGroupsNamespaceRequest.Builder.() -> Unit): DeleteRuleGroupsNamespaceResponse = deleteRuleGroupsNamespace(DeleteRuleGroupsNamespaceRequest.Builder().apply(block).build())

/**
 * Deletes an AMP workspace.
 */
public suspend inline fun AmpClient.deleteWorkspace(crossinline block: DeleteWorkspaceRequest.Builder.() -> Unit): DeleteWorkspaceResponse = deleteWorkspace(DeleteWorkspaceRequest.Builder().apply(block).build())

/**
 * Describes an alert manager definition.
 */
public suspend inline fun AmpClient.describeAlertManagerDefinition(crossinline block: DescribeAlertManagerDefinitionRequest.Builder.() -> Unit): DescribeAlertManagerDefinitionResponse = describeAlertManagerDefinition(DescribeAlertManagerDefinitionRequest.Builder().apply(block).build())

/**
 * Describes logging configuration.
 */
public suspend inline fun AmpClient.describeLoggingConfiguration(crossinline block: DescribeLoggingConfigurationRequest.Builder.() -> Unit): DescribeLoggingConfigurationResponse = describeLoggingConfiguration(DescribeLoggingConfigurationRequest.Builder().apply(block).build())

/**
 * Describe a rule groups namespace.
 */
public suspend inline fun AmpClient.describeRuleGroupsNamespace(crossinline block: DescribeRuleGroupsNamespaceRequest.Builder.() -> Unit): DescribeRuleGroupsNamespaceResponse = describeRuleGroupsNamespace(DescribeRuleGroupsNamespaceRequest.Builder().apply(block).build())

/**
 * Describes an existing AMP workspace.
 */
public suspend inline fun AmpClient.describeWorkspace(crossinline block: DescribeWorkspaceRequest.Builder.() -> Unit): DescribeWorkspaceResponse = describeWorkspace(DescribeWorkspaceRequest.Builder().apply(block).build())

/**
 * Lists rule groups namespaces.
 */
public suspend inline fun AmpClient.listRuleGroupsNamespaces(crossinline block: ListRuleGroupsNamespacesRequest.Builder.() -> Unit): ListRuleGroupsNamespacesResponse = listRuleGroupsNamespaces(ListRuleGroupsNamespacesRequest.Builder().apply(block).build())

/**
 * Lists the tags you have assigned to the resource.
 */
public suspend inline fun AmpClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists all AMP workspaces, including workspaces being created or deleted.
 */
public suspend inline fun AmpClient.listWorkspaces(crossinline block: ListWorkspacesRequest.Builder.() -> Unit): ListWorkspacesResponse = listWorkspaces(ListWorkspacesRequest.Builder().apply(block).build())

/**
 * Update an alert manager definition.
 */
public suspend inline fun AmpClient.putAlertManagerDefinition(crossinline block: PutAlertManagerDefinitionRequest.Builder.() -> Unit): PutAlertManagerDefinitionResponse = putAlertManagerDefinition(PutAlertManagerDefinitionRequest.Builder().apply(block).build())

/**
 * Update a rule groups namespace.
 */
public suspend inline fun AmpClient.putRuleGroupsNamespace(crossinline block: PutRuleGroupsNamespaceRequest.Builder.() -> Unit): PutRuleGroupsNamespaceResponse = putRuleGroupsNamespace(PutRuleGroupsNamespaceRequest.Builder().apply(block).build())

/**
 * Creates tags for the specified resource.
 */
public suspend inline fun AmpClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Deletes tags from the specified resource.
 */
public suspend inline fun AmpClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Update logging configuration.
 */
public suspend inline fun AmpClient.updateLoggingConfiguration(crossinline block: UpdateLoggingConfigurationRequest.Builder.() -> Unit): UpdateLoggingConfigurationResponse = updateLoggingConfiguration(UpdateLoggingConfigurationRequest.Builder().apply(block).build())

/**
 * Updates an AMP workspace alias.
 */
public suspend inline fun AmpClient.updateWorkspaceAlias(crossinline block: UpdateWorkspaceAliasRequest.Builder.() -> Unit): UpdateWorkspaceAliasResponse = updateWorkspaceAlias(UpdateWorkspaceAliasRequest.Builder().apply(block).build())
