// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.alexaforbusiness.serde

import aws.sdk.kotlin.services.alexaforbusiness.model.DistanceUnit
import aws.sdk.kotlin.services.alexaforbusiness.model.TemperatureUnit
import aws.sdk.kotlin.services.alexaforbusiness.model.UpdateMeetingRoomConfiguration
import aws.sdk.kotlin.services.alexaforbusiness.model.UpdateProfileRequest
import aws.sdk.kotlin.services.alexaforbusiness.model.WakeWord
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateProfileOperationSerializer: HttpSerializer.NonStreaming<UpdateProfileRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateProfileRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeUpdateProfileOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeUpdateProfileOperationBody(context: ExecutionContext, input: UpdateProfileRequest): ByteArray {
    val serializer = JsonSerializer()
    val ADDRESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Address"))
    val DATARETENTIONOPTIN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("DataRetentionOptIn"))
    val DISTANCEUNIT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("DistanceUnit"))
    val ISDEFAULT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("IsDefault"))
    val LOCALE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Locale"))
    val MAXVOLUMELIMIT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MaxVolumeLimit"))
    val MEETINGROOMCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("MeetingRoomConfiguration"))
    val PSTNENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("PSTNEnabled"))
    val PROFILEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProfileArn"))
    val PROFILENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProfileName"))
    val SETUPMODEDISABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("SetupModeDisabled"))
    val TEMPERATUREUNIT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("TemperatureUnit"))
    val TIMEZONE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Timezone"))
    val WAKEWORD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("WakeWord"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADDRESS_DESCRIPTOR)
        field(DATARETENTIONOPTIN_DESCRIPTOR)
        field(DISTANCEUNIT_DESCRIPTOR)
        field(ISDEFAULT_DESCRIPTOR)
        field(LOCALE_DESCRIPTOR)
        field(MAXVOLUMELIMIT_DESCRIPTOR)
        field(MEETINGROOMCONFIGURATION_DESCRIPTOR)
        field(PSTNENABLED_DESCRIPTOR)
        field(PROFILEARN_DESCRIPTOR)
        field(PROFILENAME_DESCRIPTOR)
        field(SETUPMODEDISABLED_DESCRIPTOR)
        field(TEMPERATUREUNIT_DESCRIPTOR)
        field(TIMEZONE_DESCRIPTOR)
        field(WAKEWORD_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.address?.let { field(ADDRESS_DESCRIPTOR, it) }
        input.dataRetentionOptIn?.let { field(DATARETENTIONOPTIN_DESCRIPTOR, it) }
        input.distanceUnit?.let { field(DISTANCEUNIT_DESCRIPTOR, it.value) }
        input.isDefault?.let { field(ISDEFAULT_DESCRIPTOR, it) }
        input.locale?.let { field(LOCALE_DESCRIPTOR, it) }
        input.maxVolumeLimit?.let { field(MAXVOLUMELIMIT_DESCRIPTOR, it) }
        input.meetingRoomConfiguration?.let { field(MEETINGROOMCONFIGURATION_DESCRIPTOR, it, ::serializeUpdateMeetingRoomConfigurationDocument) }
        input.pstnEnabled?.let { field(PSTNENABLED_DESCRIPTOR, it) }
        input.profileArn?.let { field(PROFILEARN_DESCRIPTOR, it) }
        input.profileName?.let { field(PROFILENAME_DESCRIPTOR, it) }
        input.setupModeDisabled?.let { field(SETUPMODEDISABLED_DESCRIPTOR, it) }
        input.temperatureUnit?.let { field(TEMPERATUREUNIT_DESCRIPTOR, it.value) }
        input.timezone?.let { field(TIMEZONE_DESCRIPTOR, it) }
        input.wakeWord?.let { field(WAKEWORD_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
