// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.alexaforbusiness.serde

import aws.sdk.kotlin.services.alexaforbusiness.model.AlexaForBusinessException
import aws.sdk.kotlin.services.alexaforbusiness.model.GetInvitationConfigurationResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetInvitationConfigurationOperationDeserializer: HttpDeserialize<GetInvitationConfigurationResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetInvitationConfigurationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetInvitationConfigurationError(context, call)
        }
        val builder = GetInvitationConfigurationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetInvitationConfigurationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetInvitationConfigurationError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw AlexaForBusinessException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        else -> AlexaForBusinessException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetInvitationConfigurationOperationBody(builder: GetInvitationConfigurationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONTACTEMAIL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ContactEmail"))
    val ORGANIZATIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OrganizationName"))
    val PRIVATESKILLIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("PrivateSkillIds"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONTACTEMAIL_DESCRIPTOR)
        field(ORGANIZATIONNAME_DESCRIPTOR)
        field(PRIVATESKILLIDS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONTACTEMAIL_DESCRIPTOR.index -> builder.contactEmail = deserializeString()
                ORGANIZATIONNAME_DESCRIPTOR.index -> builder.organizationName = deserializeString()
                PRIVATESKILLIDS_DESCRIPTOR.index -> builder.privateSkillIds =
                    deserializer.deserializeList(PRIVATESKILLIDS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
