// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model



/**
 * Validity specifies the period of time during which a certificate is valid. Validity
 * can be expressed as an explicit date and time when the validity of a certificate starts
 * or expires, or as a span of time after issuance, stated in days, months, or years. For
 * more information, see <a href="https://tools.ietf.org/html/rfc5280#section-4.1.2.5">Validity in RFC 5280.
 * ACM Private CA API consumes the Validity data type differently in two distinct
 * parameters of the IssueCertificate action. The required parameter
 * IssueCertificate:Validity specifies the end of a
 * certificate's validity period. The optional parameter
 * IssueCertificate:ValidityNotBefore specifies a customized
 * starting time for the validity period.
 */
class Validity private constructor(builder: Builder) {
    /**
     * Determines how ACM Private CA interprets the Value
     * parameter, an integer. Supported validity types include those listed below. Type
     * definitions with values include a sample input value and the resulting output.
     * END_DATE: The specific date and time when the certificate will expire,
     * expressed using UTCTime (YYMMDDHHMMSS) or GeneralizedTime (YYYYMMDDHHMMSS) format. When
     * UTCTime is used, if the year field (YY) is greater than or equal to 50, the year is
     * interpreted as 19YY. If the year field is less than 50, the year is interpreted as
     * 20YY.
     * Sample input value: 491231235959 (UTCTime format)
     * Output expiration date/time: 12/31/2049 23:59:59
     * ABSOLUTE: The specific date and time when the validity of a certificate
     * will start or expire, expressed in seconds since the Unix Epoch.
     * Sample input value: 2524608000
     * Output expiration date/time: 01/01/2050 00:00:00
     * DAYS, MONTHS, YEARS: The relative time from the
     * moment of issuance until the certificate will expire, expressed in days, months, or
     * years.
     * Example if DAYS, issued on 10/12/2020 at 12:34:54 UTC:
     * Sample input value: 90
     * Output expiration date: 01/10/2020 12:34:54 UTC
     * The minimum validity duration for a certificate using relative time
     * (DAYS) is one day. The minimum validity for a certificate using absolute
     * time (ABSOLUTE or END_DATE) is one second.
     */
    val type: aws.sdk.kotlin.services.acmpca.model.ValidityPeriodType? = builder.type
    /**
     * A long integer interpreted according to the value of Type, below.
     */
    val value: kotlin.Long? = builder.value

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.acmpca.model.Validity = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Validity(")
        append("type=$type,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = type?.hashCode() ?: 0
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Validity

        if (type != other.type) return false
        if (value != other.value) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.acmpca.model.Validity = Builder(this).apply(block).build()

    class Builder {
        /**
         * Determines how ACM Private CA interprets the Value
         * parameter, an integer. Supported validity types include those listed below. Type
         * definitions with values include a sample input value and the resulting output.
         * END_DATE: The specific date and time when the certificate will expire,
         * expressed using UTCTime (YYMMDDHHMMSS) or GeneralizedTime (YYYYMMDDHHMMSS) format. When
         * UTCTime is used, if the year field (YY) is greater than or equal to 50, the year is
         * interpreted as 19YY. If the year field is less than 50, the year is interpreted as
         * 20YY.
         * Sample input value: 491231235959 (UTCTime format)
         * Output expiration date/time: 12/31/2049 23:59:59
         * ABSOLUTE: The specific date and time when the validity of a certificate
         * will start or expire, expressed in seconds since the Unix Epoch.
         * Sample input value: 2524608000
         * Output expiration date/time: 01/01/2050 00:00:00
         * DAYS, MONTHS, YEARS: The relative time from the
         * moment of issuance until the certificate will expire, expressed in days, months, or
         * years.
         * Example if DAYS, issued on 10/12/2020 at 12:34:54 UTC:
         * Sample input value: 90
         * Output expiration date: 01/10/2020 12:34:54 UTC
         * The minimum validity duration for a certificate using relative time
         * (DAYS) is one day. The minimum validity for a certificate using absolute
         * time (ABSOLUTE or END_DATE) is one second.
         */
        var type: aws.sdk.kotlin.services.acmpca.model.ValidityPeriodType? = null
        /**
         * A long integer interpreted according to the value of Type, below.
         */
        var value: kotlin.Long? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.acmpca.model.Validity) : this() {
            this.type = x.type
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.acmpca.model.Validity = Validity(this)
    }
}
