// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model



class UpdateCertificateAuthorityRequest private constructor(builder: Builder) {
    /**
     * Amazon Resource Name (ARN) of the private CA that issued the certificate to be
     * revoked. This must be of the form:
     * arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
     */
    val certificateAuthorityArn: kotlin.String? = builder.certificateAuthorityArn
    /**
     * Contains information to enable Online Certificate Status Protocol (OCSP) support,
     * to enable a certificate revocation list (CRL), to enable both, or to enable neither. If
     * this parameter is not supplied, existing capibilites remain unchanged. For more
     * information, see the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_OcspConfiguration.html">OcspConfiguration and <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CrlConfiguration.html">CrlConfiguration types.
     */
    val revocationConfiguration: aws.sdk.kotlin.services.acmpca.model.RevocationConfiguration? = builder.revocationConfiguration
    /**
     * Status of your private CA.
     */
    val status: aws.sdk.kotlin.services.acmpca.model.CertificateAuthorityStatus? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.acmpca.model.UpdateCertificateAuthorityRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateCertificateAuthorityRequest(")
        append("certificateAuthorityArn=$certificateAuthorityArn,")
        append("revocationConfiguration=$revocationConfiguration,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateAuthorityArn?.hashCode() ?: 0
        result = 31 * result + (revocationConfiguration?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateCertificateAuthorityRequest

        if (certificateAuthorityArn != other.certificateAuthorityArn) return false
        if (revocationConfiguration != other.revocationConfiguration) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.acmpca.model.UpdateCertificateAuthorityRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Amazon Resource Name (ARN) of the private CA that issued the certificate to be
         * revoked. This must be of the form:
         * arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
         */
        var certificateAuthorityArn: kotlin.String? = null
        /**
         * Contains information to enable Online Certificate Status Protocol (OCSP) support,
         * to enable a certificate revocation list (CRL), to enable both, or to enable neither. If
         * this parameter is not supplied, existing capibilites remain unchanged. For more
         * information, see the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_OcspConfiguration.html">OcspConfiguration and <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CrlConfiguration.html">CrlConfiguration types.
         */
        var revocationConfiguration: aws.sdk.kotlin.services.acmpca.model.RevocationConfiguration? = null
        /**
         * Status of your private CA.
         */
        var status: aws.sdk.kotlin.services.acmpca.model.CertificateAuthorityStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.acmpca.model.UpdateCertificateAuthorityRequest) : this() {
            this.certificateAuthorityArn = x.certificateAuthorityArn
            this.revocationConfiguration = x.revocationConfiguration
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.acmpca.model.UpdateCertificateAuthorityRequest = UpdateCertificateAuthorityRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.acmpca.model.RevocationConfiguration] inside the given [block]
         */
        fun revocationConfiguration(block: aws.sdk.kotlin.services.acmpca.model.RevocationConfiguration.Builder.() -> kotlin.Unit) {
            this.revocationConfiguration = aws.sdk.kotlin.services.acmpca.model.RevocationConfiguration.invoke(block)
        }
    }
}
