// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model



class PutPolicyRequest private constructor(builder: Builder) {
    /**
     * The path and file name of a JSON-formatted IAM policy to attach to the specified
     * private CA resource. If this policy does not contain all required statements or if it
     * includes any statement that is not allowed, the PutPolicy action returns an
     * InvalidPolicyException. For information about IAM policy and
     * statement structure, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json">Overview of JSON Policies.
     */
    val policy: kotlin.String? = builder.policy
    /**
     * The Amazon Resource Number (ARN) of the private CA to associate with the policy. The
     * ARN of the CA can be found by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities action.
     */
    val resourceArn: kotlin.String? = builder.resourceArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.acmpca.model.PutPolicyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutPolicyRequest(")
        append("policy=$policy,")
        append("resourceArn=$resourceArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = policy?.hashCode() ?: 0
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PutPolicyRequest

        if (policy != other.policy) return false
        if (resourceArn != other.resourceArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.acmpca.model.PutPolicyRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The path and file name of a JSON-formatted IAM policy to attach to the specified
         * private CA resource. If this policy does not contain all required statements or if it
         * includes any statement that is not allowed, the PutPolicy action returns an
         * InvalidPolicyException. For information about IAM policy and
         * statement structure, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json">Overview of JSON Policies.
         */
        var policy: kotlin.String? = null
        /**
         * The Amazon Resource Number (ARN) of the private CA to associate with the policy. The
         * ARN of the CA can be found by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities action.
         */
        var resourceArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.acmpca.model.PutPolicyRequest) : this() {
            this.policy = x.policy
            this.resourceArn = x.resourceArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.acmpca.model.PutPolicyRequest = PutPolicyRequest(this)
    }
}
