// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model



/**
 * Defines the X.509 CertificatePolicies extension.
 */
class PolicyInformation private constructor(builder: Builder) {
    /**
     * Specifies the object identifier (OID) of the certificate policy under which the
     * certificate was issued. For more information, see NIST's definition of <a href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier
     * (OID).
     */
    val certPolicyId: kotlin.String? = builder.certPolicyId
    /**
     * Modifies the given CertPolicyId with a qualifier. ACM Private CA supports the
     * certification practice statement (CPS) qualifier.
     */
    val policyQualifiers: List<PolicyQualifierInfo>? = builder.policyQualifiers

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.acmpca.model.PolicyInformation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PolicyInformation(")
        append("certPolicyId=$certPolicyId,")
        append("policyQualifiers=$policyQualifiers)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certPolicyId?.hashCode() ?: 0
        result = 31 * result + (policyQualifiers?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PolicyInformation

        if (certPolicyId != other.certPolicyId) return false
        if (policyQualifiers != other.policyQualifiers) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.acmpca.model.PolicyInformation = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies the object identifier (OID) of the certificate policy under which the
         * certificate was issued. For more information, see NIST's definition of <a href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier
         * (OID).
         */
        var certPolicyId: kotlin.String? = null
        /**
         * Modifies the given CertPolicyId with a qualifier. ACM Private CA supports the
         * certification practice statement (CPS) qualifier.
         */
        var policyQualifiers: List<PolicyQualifierInfo>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.acmpca.model.PolicyInformation) : this() {
            this.certPolicyId = x.certPolicyId
            this.policyQualifiers = x.policyQualifiers
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.acmpca.model.PolicyInformation = PolicyInformation(this)
    }
}
