// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Permissions designate which private CA actions can be performed by an AWS service or
 * entity. In order for ACM to automatically renew private certificates, you must give
 * the ACM service principal all available permissions (IssueCertificate,
 * GetCertificate, and ListPermissions). Permissions can be
 * assigned with the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreatePermission.html">CreatePermission action,
 * removed with the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeletePermission.html">DeletePermission action, and
 * listed with the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListPermissions.html">ListPermissions action.
 */
class Permission private constructor(builder: Builder) {
    /**
     * The private CA actions that can be performed by the designated AWS service.
     */
    val actions: List<ActionType>? = builder.actions
    /**
     * The Amazon Resource Number (ARN) of the private CA from which the permission was
     * issued.
     */
    val certificateAuthorityArn: kotlin.String? = builder.certificateAuthorityArn
    /**
     * The time at which the permission was created.
     */
    val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The name of the policy that is associated with the permission.
     */
    val policy: kotlin.String? = builder.policy
    /**
     * The AWS service or entity that holds the permission. At this time, the only valid
     * principal is acm.amazonaws.com.
     */
    val principal: kotlin.String? = builder.principal
    /**
     * The ID of the account that assigned the permission.
     */
    val sourceAccount: kotlin.String? = builder.sourceAccount

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.acmpca.model.Permission = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Permission(")
        append("actions=$actions,")
        append("certificateAuthorityArn=$certificateAuthorityArn,")
        append("createdAt=$createdAt,")
        append("policy=$policy,")
        append("principal=$principal,")
        append("sourceAccount=$sourceAccount)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actions?.hashCode() ?: 0
        result = 31 * result + (certificateAuthorityArn?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (policy?.hashCode() ?: 0)
        result = 31 * result + (principal?.hashCode() ?: 0)
        result = 31 * result + (sourceAccount?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Permission

        if (actions != other.actions) return false
        if (certificateAuthorityArn != other.certificateAuthorityArn) return false
        if (createdAt != other.createdAt) return false
        if (policy != other.policy) return false
        if (principal != other.principal) return false
        if (sourceAccount != other.sourceAccount) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.acmpca.model.Permission = Builder(this).apply(block).build()

    class Builder {
        /**
         * The private CA actions that can be performed by the designated AWS service.
         */
        var actions: List<ActionType>? = null
        /**
         * The Amazon Resource Number (ARN) of the private CA from which the permission was
         * issued.
         */
        var certificateAuthorityArn: kotlin.String? = null
        /**
         * The time at which the permission was created.
         */
        var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the policy that is associated with the permission.
         */
        var policy: kotlin.String? = null
        /**
         * The AWS service or entity that holds the permission. At this time, the only valid
         * principal is acm.amazonaws.com.
         */
        var principal: kotlin.String? = null
        /**
         * The ID of the account that assigned the permission.
         */
        var sourceAccount: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.acmpca.model.Permission) : this() {
            this.actions = x.actions
            this.certificateAuthorityArn = x.certificateAuthorityArn
            this.createdAt = x.createdAt
            this.policy = x.policy
            this.principal = x.principal
            this.sourceAccount = x.sourceAccount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.acmpca.model.Permission = Permission(this)
    }
}
