// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model



/**
 * Contains information to enable and configure Online Certificate Status Protocol (OCSP) for
 * validating certificate revocation status.
 * When you revoke a certificate, OCSP responses may take up to 60 minutes
 * to reflect the new status.
 */
class OcspConfiguration private constructor(builder: Builder) {
    /**
     * Flag enabling use of the Online Certificate Status Protocol (OCSP) for validating
     * certificate revocation status.
     */
    val enabled: kotlin.Boolean = builder.enabled
    /**
     * By default, ACM Private CA injects an AWS domain into certificates being validated by the
     * Online Certificate Status Protocol (OCSP). A customer can alternatively use this object
     * to define a CNAME specifying a customized OCSP domain.
     * Note: The value of the CNAME must not include a protocol prefix such as "http://" or
     * "https://".
     * For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/ocsp-customize.html">Customizing Online Certificate
     * Status Protocol (OCSP)  in the AWS Certificate Manager Private Certificate Authority (PCA) User
     * Guide.
     */
    val ocspCustomCname: kotlin.String? = builder.ocspCustomCname

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.acmpca.model.OcspConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OcspConfiguration(")
        append("enabled=$enabled,")
        append("ocspCustomCname=$ocspCustomCname)")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled.hashCode()
        result = 31 * result + (ocspCustomCname?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as OcspConfiguration

        if (enabled != other.enabled) return false
        if (ocspCustomCname != other.ocspCustomCname) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.acmpca.model.OcspConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * Flag enabling use of the Online Certificate Status Protocol (OCSP) for validating
         * certificate revocation status.
         */
        var enabled: kotlin.Boolean = false
        /**
         * By default, ACM Private CA injects an AWS domain into certificates being validated by the
         * Online Certificate Status Protocol (OCSP). A customer can alternatively use this object
         * to define a CNAME specifying a customized OCSP domain.
         * Note: The value of the CNAME must not include a protocol prefix such as "http://" or
         * "https://".
         * For more information, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/ocsp-customize.html">Customizing Online Certificate
         * Status Protocol (OCSP)  in the AWS Certificate Manager Private Certificate Authority (PCA) User
         * Guide.
         */
        var ocspCustomCname: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.acmpca.model.OcspConfiguration) : this() {
            this.enabled = x.enabled
            this.ocspCustomCname = x.ocspCustomCname
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.acmpca.model.OcspConfiguration = OcspConfiguration(this)
    }
}
