// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model



class ListPermissionsRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Number (ARN) of the private CA to inspect. You can find the ARN by
     * calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities action. This must be of the form:
     * arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
     * You can get a private CA's ARN by running the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities action.
     */
    val certificateAuthorityArn: kotlin.String? = builder.certificateAuthorityArn
    /**
     * When paginating results, use this parameter to specify the maximum number of items to
     * return in the response. If additional items exist beyond the number you specify, the
     * NextToken element is sent in the response. Use this
     * NextToken value in a subsequent request to retrieve
     * additional items.
     */
    val maxResults: kotlin.Int? = builder.maxResults
    /**
     * When paginating results, use this parameter in a subsequent request after you receive
     * a response with truncated results. Set it to the value of NextToken from the response you just received.
     */
    val nextToken: kotlin.String? = builder.nextToken

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.acmpca.model.ListPermissionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListPermissionsRequest(")
        append("certificateAuthorityArn=$certificateAuthorityArn,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateAuthorityArn?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListPermissionsRequest

        if (certificateAuthorityArn != other.certificateAuthorityArn) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.acmpca.model.ListPermissionsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Number (ARN) of the private CA to inspect. You can find the ARN by
         * calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities action. This must be of the form:
         * arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
         * You can get a private CA's ARN by running the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities action.
         */
        var certificateAuthorityArn: kotlin.String? = null
        /**
         * When paginating results, use this parameter to specify the maximum number of items to
         * return in the response. If additional items exist beyond the number you specify, the
         * NextToken element is sent in the response. Use this
         * NextToken value in a subsequent request to retrieve
         * additional items.
         */
        var maxResults: kotlin.Int? = null
        /**
         * When paginating results, use this parameter in a subsequent request after you receive
         * a response with truncated results. Set it to the value of NextToken from the response you just received.
         */
        var nextToken: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.acmpca.model.ListPermissionsRequest) : this() {
            this.certificateAuthorityArn = x.certificateAuthorityArn
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.acmpca.model.ListPermissionsRequest = ListPermissionsRequest(this)
    }
}
