// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model



/**
 * Describes an ASN.1 X.400 GeneralName as defined in <a href="https://tools.ietf.org/html/rfc5280">RFC 5280. Only one of the
 * following naming options should be provided. Providing more than one option results in
 * an InvalidArgsException error.
 */
class GeneralName private constructor(builder: Builder) {
    /**
     * Contains information about the certificate subject. The Subject field in
     * the certificate identifies the entity that owns or controls the public key in the
     * certificate. The entity can be a user, computer, device, or service. The Subject
     * must contain an X.500 distinguished name (DN). A DN is a sequence of relative
     * distinguished names (RDNs). The RDNs are separated by commas in the certificate.
     */
    val directoryName: aws.sdk.kotlin.services.acmpca.model.Asn1Subject? = builder.directoryName
    /**
     * Represents GeneralName as a DNS name.
     */
    val dnsName: kotlin.String? = builder.dnsName
    /**
     * Represents GeneralName as an EdiPartyName object.
     */
    val ediPartyName: aws.sdk.kotlin.services.acmpca.model.EdiPartyName? = builder.ediPartyName
    /**
     * Represents GeneralName as an IPv4 or IPv6 address.
     */
    val ipAddress: kotlin.String? = builder.ipAddress
    /**
     * Represents GeneralName using an OtherName object.
     */
    val otherName: aws.sdk.kotlin.services.acmpca.model.OtherName? = builder.otherName
    /**
     * Represents GeneralName as an object identifier (OID).
     */
    val registeredId: kotlin.String? = builder.registeredId
    /**
     * Represents GeneralName as an <a href="https://tools.ietf.org/html/rfc822">RFC 822 email address.
     */
    val rfc822Name: kotlin.String? = builder.rfc822Name
    /**
     * Represents GeneralName as a URI.
     */
    val uniformResourceIdentifier: kotlin.String? = builder.uniformResourceIdentifier

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.acmpca.model.GeneralName = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GeneralName(")
        append("directoryName=$directoryName,")
        append("dnsName=$dnsName,")
        append("ediPartyName=$ediPartyName,")
        append("ipAddress=$ipAddress,")
        append("otherName=$otherName,")
        append("registeredId=$registeredId,")
        append("rfc822Name=$rfc822Name,")
        append("uniformResourceIdentifier=$uniformResourceIdentifier)")
    }

    override fun hashCode(): kotlin.Int {
        var result = directoryName?.hashCode() ?: 0
        result = 31 * result + (dnsName?.hashCode() ?: 0)
        result = 31 * result + (ediPartyName?.hashCode() ?: 0)
        result = 31 * result + (ipAddress?.hashCode() ?: 0)
        result = 31 * result + (otherName?.hashCode() ?: 0)
        result = 31 * result + (registeredId?.hashCode() ?: 0)
        result = 31 * result + (rfc822Name?.hashCode() ?: 0)
        result = 31 * result + (uniformResourceIdentifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GeneralName

        if (directoryName != other.directoryName) return false
        if (dnsName != other.dnsName) return false
        if (ediPartyName != other.ediPartyName) return false
        if (ipAddress != other.ipAddress) return false
        if (otherName != other.otherName) return false
        if (registeredId != other.registeredId) return false
        if (rfc822Name != other.rfc822Name) return false
        if (uniformResourceIdentifier != other.uniformResourceIdentifier) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.acmpca.model.GeneralName = Builder(this).apply(block).build()

    class Builder {
        /**
         * Contains information about the certificate subject. The Subject field in
         * the certificate identifies the entity that owns or controls the public key in the
         * certificate. The entity can be a user, computer, device, or service. The Subject
         * must contain an X.500 distinguished name (DN). A DN is a sequence of relative
         * distinguished names (RDNs). The RDNs are separated by commas in the certificate.
         */
        var directoryName: aws.sdk.kotlin.services.acmpca.model.Asn1Subject? = null
        /**
         * Represents GeneralName as a DNS name.
         */
        var dnsName: kotlin.String? = null
        /**
         * Represents GeneralName as an EdiPartyName object.
         */
        var ediPartyName: aws.sdk.kotlin.services.acmpca.model.EdiPartyName? = null
        /**
         * Represents GeneralName as an IPv4 or IPv6 address.
         */
        var ipAddress: kotlin.String? = null
        /**
         * Represents GeneralName using an OtherName object.
         */
        var otherName: aws.sdk.kotlin.services.acmpca.model.OtherName? = null
        /**
         * Represents GeneralName as an object identifier (OID).
         */
        var registeredId: kotlin.String? = null
        /**
         * Represents GeneralName as an <a href="https://tools.ietf.org/html/rfc822">RFC 822 email address.
         */
        var rfc822Name: kotlin.String? = null
        /**
         * Represents GeneralName as a URI.
         */
        var uniformResourceIdentifier: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.acmpca.model.GeneralName) : this() {
            this.directoryName = x.directoryName
            this.dnsName = x.dnsName
            this.ediPartyName = x.ediPartyName
            this.ipAddress = x.ipAddress
            this.otherName = x.otherName
            this.registeredId = x.registeredId
            this.rfc822Name = x.rfc822Name
            this.uniformResourceIdentifier = x.uniformResourceIdentifier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.acmpca.model.GeneralName = GeneralName(this)

        /**
         * construct an [aws.sdk.kotlin.services.acmpca.model.Asn1Subject] inside the given [block]
         */
        fun directoryName(block: aws.sdk.kotlin.services.acmpca.model.Asn1Subject.Builder.() -> kotlin.Unit) {
            this.directoryName = aws.sdk.kotlin.services.acmpca.model.Asn1Subject.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.acmpca.model.EdiPartyName] inside the given [block]
         */
        fun ediPartyName(block: aws.sdk.kotlin.services.acmpca.model.EdiPartyName.Builder.() -> kotlin.Unit) {
            this.ediPartyName = aws.sdk.kotlin.services.acmpca.model.EdiPartyName.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.acmpca.model.OtherName] inside the given [block]
         */
        fun otherName(block: aws.sdk.kotlin.services.acmpca.model.OtherName.Builder.() -> kotlin.Unit) {
            this.otherName = aws.sdk.kotlin.services.acmpca.model.OtherName.invoke(block)
        }
    }
}
