// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model



/**
 * Specifies additional purposes for which the certified public key may be used other
 * than basic purposes indicated in the KeyUsage extension.
 */
class ExtendedKeyUsage private constructor(builder: Builder) {
    /**
     * Specifies a custom ExtendedKeyUsage with an object identifier
     * (OID).
     */
    val extendedKeyUsageObjectIdentifier: kotlin.String? = builder.extendedKeyUsageObjectIdentifier
    /**
     * Specifies a standard ExtendedKeyUsage as defined as in <a href="https://tools.ietf.org/html/rfc5280#section-4.2.1.12">RFC 5280.
     */
    val extendedKeyUsageType: aws.sdk.kotlin.services.acmpca.model.ExtendedKeyUsageType? = builder.extendedKeyUsageType

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.acmpca.model.ExtendedKeyUsage = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExtendedKeyUsage(")
        append("extendedKeyUsageObjectIdentifier=$extendedKeyUsageObjectIdentifier,")
        append("extendedKeyUsageType=$extendedKeyUsageType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = extendedKeyUsageObjectIdentifier?.hashCode() ?: 0
        result = 31 * result + (extendedKeyUsageType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ExtendedKeyUsage

        if (extendedKeyUsageObjectIdentifier != other.extendedKeyUsageObjectIdentifier) return false
        if (extendedKeyUsageType != other.extendedKeyUsageType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.acmpca.model.ExtendedKeyUsage = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies a custom ExtendedKeyUsage with an object identifier
         * (OID).
         */
        var extendedKeyUsageObjectIdentifier: kotlin.String? = null
        /**
         * Specifies a standard ExtendedKeyUsage as defined as in <a href="https://tools.ietf.org/html/rfc5280#section-4.2.1.12">RFC 5280.
         */
        var extendedKeyUsageType: aws.sdk.kotlin.services.acmpca.model.ExtendedKeyUsageType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.acmpca.model.ExtendedKeyUsage) : this() {
            this.extendedKeyUsageObjectIdentifier = x.extendedKeyUsageObjectIdentifier
            this.extendedKeyUsageType = x.extendedKeyUsageType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.acmpca.model.ExtendedKeyUsage = ExtendedKeyUsage(this)
    }
}
