// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model



class CreatePermissionRequest private constructor(builder: Builder) {
    /**
     * The actions that the specified AWS service principal can use. These include
     * IssueCertificate, GetCertificate, and
     * ListPermissions.
     */
    val actions: List<ActionType>? = builder.actions
    /**
     * The Amazon Resource Name (ARN) of the CA that grants the permissions. You can find the
     * ARN by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities action. This must have the following form:
     * arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
     * .
     */
    val certificateAuthorityArn: kotlin.String? = builder.certificateAuthorityArn
    /**
     * The AWS service or identity that receives the permission. At this time, the only
     * valid principal is acm.amazonaws.com.
     */
    val principal: kotlin.String? = builder.principal
    /**
     * The ID of the calling account.
     */
    val sourceAccount: kotlin.String? = builder.sourceAccount

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.acmpca.model.CreatePermissionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreatePermissionRequest(")
        append("actions=$actions,")
        append("certificateAuthorityArn=$certificateAuthorityArn,")
        append("principal=$principal,")
        append("sourceAccount=$sourceAccount)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actions?.hashCode() ?: 0
        result = 31 * result + (certificateAuthorityArn?.hashCode() ?: 0)
        result = 31 * result + (principal?.hashCode() ?: 0)
        result = 31 * result + (sourceAccount?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreatePermissionRequest

        if (actions != other.actions) return false
        if (certificateAuthorityArn != other.certificateAuthorityArn) return false
        if (principal != other.principal) return false
        if (sourceAccount != other.sourceAccount) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.acmpca.model.CreatePermissionRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The actions that the specified AWS service principal can use. These include
         * IssueCertificate, GetCertificate, and
         * ListPermissions.
         */
        var actions: List<ActionType>? = null
        /**
         * The Amazon Resource Name (ARN) of the CA that grants the permissions. You can find the
         * ARN by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities action. This must have the following form:
         * arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
         * .
         */
        var certificateAuthorityArn: kotlin.String? = null
        /**
         * The AWS service or identity that receives the permission. At this time, the only
         * valid principal is acm.amazonaws.com.
         */
        var principal: kotlin.String? = null
        /**
         * The ID of the calling account.
         */
        var sourceAccount: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.acmpca.model.CreatePermissionRequest) : this() {
            this.actions = x.actions
            this.certificateAuthorityArn = x.certificateAuthorityArn
            this.principal = x.principal
            this.sourceAccount = x.sourceAccount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.acmpca.model.CreatePermissionRequest = CreatePermissionRequest(this)
    }
}
