// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model



class CreateCertificateAuthorityRequest private constructor(builder: Builder) {
    /**
     * Name and bit size of the private key algorithm, the name of the signing algorithm, and
     * X.500 certificate subject information.
     */
    val certificateAuthorityConfiguration: aws.sdk.kotlin.services.acmpca.model.CertificateAuthorityConfiguration? = builder.certificateAuthorityConfiguration
    /**
     * The type of the certificate authority.
     */
    val certificateAuthorityType: aws.sdk.kotlin.services.acmpca.model.CertificateAuthorityType? = builder.certificateAuthorityType
    /**
     * Custom string that can be used to distinguish between calls to the CreateCertificateAuthority action. Idempotency tokens for
     * CreateCertificateAuthority time out after five
     * minutes. Therefore, if you call CreateCertificateAuthority multiple times with the same idempotency
     * token within five minutes, ACM Private CA recognizes that you are requesting only certificate
     * authority and will issue only one. If you change the idempotency token for each call,
     * PCA recognizes that you are requesting multiple certificate authorities.
     */
    val idempotencyToken: kotlin.String? = builder.idempotencyToken
    /**
     * Specifies a
     * cryptographic key management compliance standard used for handling CA keys.
     * Default: FIPS_140_2_LEVEL_3_OR_HIGHER
     * Note: FIPS_140_2_LEVEL_3_OR_HIGHER is not supported in Region
     * ap-northeast-3. When creating a CA in the ap-northeast-3, you must provide
     * FIPS_140_2_LEVEL_2_OR_HIGHER as the argument for
     * KeyStorageSecurityStandard. Failure to do this results in an
     * InvalidArgsException with the message, "A certificate authority cannot
     * be created in this region with the specified security standard."
     */
    val keyStorageSecurityStandard: aws.sdk.kotlin.services.acmpca.model.KeyStorageSecurityStandard? = builder.keyStorageSecurityStandard
    /**
     * Contains information to enable Online Certificate Status Protocol (OCSP) support,
     * to enable a certificate revocation list (CRL), to enable both, or to enable neither. The
     * default is for both certificate validation mechanisms to be disabled. For more
     * information, see the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_OcspConfiguration.html">OcspConfiguration and <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CrlConfiguration.html">CrlConfiguration types.
     */
    val revocationConfiguration: aws.sdk.kotlin.services.acmpca.model.RevocationConfiguration? = builder.revocationConfiguration
    /**
     * Key-value pairs that will be attached to the new private CA. You can associate up to
     * 50 tags with a private CA. For information using tags with IAM to manage permissions,
     * see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM Tags.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.acmpca.model.CreateCertificateAuthorityRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateCertificateAuthorityRequest(")
        append("certificateAuthorityConfiguration=$certificateAuthorityConfiguration,")
        append("certificateAuthorityType=$certificateAuthorityType,")
        append("idempotencyToken=$idempotencyToken,")
        append("keyStorageSecurityStandard=$keyStorageSecurityStandard,")
        append("revocationConfiguration=$revocationConfiguration,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateAuthorityConfiguration?.hashCode() ?: 0
        result = 31 * result + (certificateAuthorityType?.hashCode() ?: 0)
        result = 31 * result + (idempotencyToken?.hashCode() ?: 0)
        result = 31 * result + (keyStorageSecurityStandard?.hashCode() ?: 0)
        result = 31 * result + (revocationConfiguration?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateCertificateAuthorityRequest

        if (certificateAuthorityConfiguration != other.certificateAuthorityConfiguration) return false
        if (certificateAuthorityType != other.certificateAuthorityType) return false
        if (idempotencyToken != other.idempotencyToken) return false
        if (keyStorageSecurityStandard != other.keyStorageSecurityStandard) return false
        if (revocationConfiguration != other.revocationConfiguration) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.acmpca.model.CreateCertificateAuthorityRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Name and bit size of the private key algorithm, the name of the signing algorithm, and
         * X.500 certificate subject information.
         */
        var certificateAuthorityConfiguration: aws.sdk.kotlin.services.acmpca.model.CertificateAuthorityConfiguration? = null
        /**
         * The type of the certificate authority.
         */
        var certificateAuthorityType: aws.sdk.kotlin.services.acmpca.model.CertificateAuthorityType? = null
        /**
         * Custom string that can be used to distinguish between calls to the CreateCertificateAuthority action. Idempotency tokens for
         * CreateCertificateAuthority time out after five
         * minutes. Therefore, if you call CreateCertificateAuthority multiple times with the same idempotency
         * token within five minutes, ACM Private CA recognizes that you are requesting only certificate
         * authority and will issue only one. If you change the idempotency token for each call,
         * PCA recognizes that you are requesting multiple certificate authorities.
         */
        var idempotencyToken: kotlin.String? = null
        /**
         * Specifies a
         * cryptographic key management compliance standard used for handling CA keys.
         * Default: FIPS_140_2_LEVEL_3_OR_HIGHER
         * Note: FIPS_140_2_LEVEL_3_OR_HIGHER is not supported in Region
         * ap-northeast-3. When creating a CA in the ap-northeast-3, you must provide
         * FIPS_140_2_LEVEL_2_OR_HIGHER as the argument for
         * KeyStorageSecurityStandard. Failure to do this results in an
         * InvalidArgsException with the message, "A certificate authority cannot
         * be created in this region with the specified security standard."
         */
        var keyStorageSecurityStandard: aws.sdk.kotlin.services.acmpca.model.KeyStorageSecurityStandard? = null
        /**
         * Contains information to enable Online Certificate Status Protocol (OCSP) support,
         * to enable a certificate revocation list (CRL), to enable both, or to enable neither. The
         * default is for both certificate validation mechanisms to be disabled. For more
         * information, see the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_OcspConfiguration.html">OcspConfiguration and <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CrlConfiguration.html">CrlConfiguration types.
         */
        var revocationConfiguration: aws.sdk.kotlin.services.acmpca.model.RevocationConfiguration? = null
        /**
         * Key-value pairs that will be attached to the new private CA. You can associate up to
         * 50 tags with a private CA. For information using tags with IAM to manage permissions,
         * see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html">Controlling Access Using IAM Tags.
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.acmpca.model.CreateCertificateAuthorityRequest) : this() {
            this.certificateAuthorityConfiguration = x.certificateAuthorityConfiguration
            this.certificateAuthorityType = x.certificateAuthorityType
            this.idempotencyToken = x.idempotencyToken
            this.keyStorageSecurityStandard = x.keyStorageSecurityStandard
            this.revocationConfiguration = x.revocationConfiguration
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.acmpca.model.CreateCertificateAuthorityRequest = CreateCertificateAuthorityRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.acmpca.model.CertificateAuthorityConfiguration] inside the given [block]
         */
        fun certificateAuthorityConfiguration(block: aws.sdk.kotlin.services.acmpca.model.CertificateAuthorityConfiguration.Builder.() -> kotlin.Unit) {
            this.certificateAuthorityConfiguration = aws.sdk.kotlin.services.acmpca.model.CertificateAuthorityConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.acmpca.model.RevocationConfiguration] inside the given [block]
         */
        fun revocationConfiguration(block: aws.sdk.kotlin.services.acmpca.model.RevocationConfiguration.Builder.() -> kotlin.Unit) {
            this.revocationConfiguration = aws.sdk.kotlin.services.acmpca.model.RevocationConfiguration.invoke(block)
        }
    }
}
