// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model



/**
 * Contains configuration information for your private certificate authority (CA). This
 * includes information about the class of public key algorithm and the key pair that your
 * private CA creates when it issues a certificate. It also includes the signature
 * algorithm that it uses when issuing certificates, and its X.500 distinguished name. You
 * must specify this information when you call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority action.
 */
class CertificateAuthorityConfiguration private constructor(builder: Builder) {
    /**
     * Specifies information to be added to the extension section of the certificate signing
     * request (CSR).
     */
    val csrExtensions: aws.sdk.kotlin.services.acmpca.model.CsrExtensions? = builder.csrExtensions
    /**
     * Type of the public key algorithm and size, in bits, of the key pair that your CA
     * creates when it issues a certificate. When you create a subordinate CA, you must use a
     * key algorithm supported by the parent CA.
     */
    val keyAlgorithm: aws.sdk.kotlin.services.acmpca.model.KeyAlgorithm? = builder.keyAlgorithm
    /**
     * Name of the algorithm your private CA uses to sign certificate requests.
     * This parameter should not be confused with the SigningAlgorithm parameter
     * used to sign certificates when they are issued.
     */
    val signingAlgorithm: aws.sdk.kotlin.services.acmpca.model.SigningAlgorithm? = builder.signingAlgorithm
    /**
     * Structure that contains X.500 distinguished name information for your private
     * CA.
     */
    val subject: aws.sdk.kotlin.services.acmpca.model.Asn1Subject? = builder.subject

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.acmpca.model.CertificateAuthorityConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CertificateAuthorityConfiguration(")
        append("csrExtensions=$csrExtensions,")
        append("keyAlgorithm=$keyAlgorithm,")
        append("signingAlgorithm=$signingAlgorithm,")
        append("subject=$subject)")
    }

    override fun hashCode(): kotlin.Int {
        var result = csrExtensions?.hashCode() ?: 0
        result = 31 * result + (keyAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (signingAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (subject?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CertificateAuthorityConfiguration

        if (csrExtensions != other.csrExtensions) return false
        if (keyAlgorithm != other.keyAlgorithm) return false
        if (signingAlgorithm != other.signingAlgorithm) return false
        if (subject != other.subject) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.acmpca.model.CertificateAuthorityConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies information to be added to the extension section of the certificate signing
         * request (CSR).
         */
        var csrExtensions: aws.sdk.kotlin.services.acmpca.model.CsrExtensions? = null
        /**
         * Type of the public key algorithm and size, in bits, of the key pair that your CA
         * creates when it issues a certificate. When you create a subordinate CA, you must use a
         * key algorithm supported by the parent CA.
         */
        var keyAlgorithm: aws.sdk.kotlin.services.acmpca.model.KeyAlgorithm? = null
        /**
         * Name of the algorithm your private CA uses to sign certificate requests.
         * This parameter should not be confused with the SigningAlgorithm parameter
         * used to sign certificates when they are issued.
         */
        var signingAlgorithm: aws.sdk.kotlin.services.acmpca.model.SigningAlgorithm? = null
        /**
         * Structure that contains X.500 distinguished name information for your private
         * CA.
         */
        var subject: aws.sdk.kotlin.services.acmpca.model.Asn1Subject? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.acmpca.model.CertificateAuthorityConfiguration) : this() {
            this.csrExtensions = x.csrExtensions
            this.keyAlgorithm = x.keyAlgorithm
            this.signingAlgorithm = x.signingAlgorithm
            this.subject = x.subject
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.acmpca.model.CertificateAuthorityConfiguration = CertificateAuthorityConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.acmpca.model.CsrExtensions] inside the given [block]
         */
        fun csrExtensions(block: aws.sdk.kotlin.services.acmpca.model.CsrExtensions.Builder.() -> kotlin.Unit) {
            this.csrExtensions = aws.sdk.kotlin.services.acmpca.model.CsrExtensions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.acmpca.model.Asn1Subject] inside the given [block]
         */
        fun subject(block: aws.sdk.kotlin.services.acmpca.model.Asn1Subject.Builder.() -> kotlin.Unit) {
            this.subject = aws.sdk.kotlin.services.acmpca.model.Asn1Subject.invoke(block)
        }
    }
}
