// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about your private certificate authority (CA). Your private CA
 * can issue and revoke X.509 digital certificates. Digital certificates verify that the
 * entity named in the certificate Subject field owns or
 * controls the public key contained in the Subject Public Key
 * Info field. Call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html">CreateCertificateAuthority action to create your private CA. You must then
 * call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetCertificateAuthorityCertificate.html">GetCertificateAuthorityCertificate action to retrieve a private CA
 * certificate signing request (CSR). Sign the CSR with your ACM Private CA-hosted or on-premises
 * root or subordinate CA certificate. Call the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ImportCertificateAuthorityCertificate.html">ImportCertificateAuthorityCertificate action to import the signed
 * certificate into AWS Certificate Manager (ACM).
 */
class CertificateAuthority private constructor(builder: Builder) {
    /**
     * Amazon Resource Name (ARN) for your private certificate authority (CA). The format is
     * 12345678-1234-1234-1234-123456789012
     * .
     */
    val arn: kotlin.String? = builder.arn
    /**
     * Your private CA configuration.
     */
    val certificateAuthorityConfiguration: aws.sdk.kotlin.services.acmpca.model.CertificateAuthorityConfiguration? = builder.certificateAuthorityConfiguration
    /**
     * Date and time at which your private CA was created.
     */
    val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * Reason the request to create your private CA failed.
     */
    val failureReason: aws.sdk.kotlin.services.acmpca.model.FailureReason? = builder.failureReason
    /**
     * Defines a cryptographic key management compliance standard used for handling CA keys.
     * Default: FIPS_140_2_LEVEL_3_OR_HIGHER
     * Note: AWS Region ap-northeast-3 supports only FIPS_140_2_LEVEL_2_OR_HIGHER. You must
     * explicitly specify this parameter and value when creating a CA in that Region.
     * Specifying a different value (or no value) results in an
     * InvalidArgsException with the message "A certificate authority cannot
     * be created in this region with the specified security standard."
     */
    val keyStorageSecurityStandard: aws.sdk.kotlin.services.acmpca.model.KeyStorageSecurityStandard? = builder.keyStorageSecurityStandard
    /**
     * Date and time at which your private CA was last updated.
     */
    val lastStateChangeAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastStateChangeAt
    /**
     * Date and time after which your private CA certificate is not valid.
     */
    val notAfter: aws.smithy.kotlin.runtime.time.Instant? = builder.notAfter
    /**
     * Date and time before which your private CA certificate is not valid.
     */
    val notBefore: aws.smithy.kotlin.runtime.time.Instant? = builder.notBefore
    /**
     * The AWS account ID that owns the certificate authority.
     */
    val ownerAccount: kotlin.String? = builder.ownerAccount
    /**
     * The period during which a deleted CA can be restored. For more information, see the
     * PermanentDeletionTimeInDays parameter of the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeleteCertificateAuthorityRequest.html">DeleteCertificateAuthorityRequest action.
     */
    val restorableUntil: aws.smithy.kotlin.runtime.time.Instant? = builder.restorableUntil
    /**
     * Information about the Online Certificate Status Protocol (OCSP) configuration or
     * certificate revocation list (CRL) created and maintained by your private CA.
     */
    val revocationConfiguration: aws.sdk.kotlin.services.acmpca.model.RevocationConfiguration? = builder.revocationConfiguration
    /**
     * Serial number of your private CA.
     */
    val serial: kotlin.String? = builder.serial
    /**
     * Status of your private CA.
     */
    val status: aws.sdk.kotlin.services.acmpca.model.CertificateAuthorityStatus? = builder.status
    /**
     * Type of your private CA.
     */
    val type: aws.sdk.kotlin.services.acmpca.model.CertificateAuthorityType? = builder.type

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.acmpca.model.CertificateAuthority = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CertificateAuthority(")
        append("arn=$arn,")
        append("certificateAuthorityConfiguration=$certificateAuthorityConfiguration,")
        append("createdAt=$createdAt,")
        append("failureReason=$failureReason,")
        append("keyStorageSecurityStandard=$keyStorageSecurityStandard,")
        append("lastStateChangeAt=$lastStateChangeAt,")
        append("notAfter=$notAfter,")
        append("notBefore=$notBefore,")
        append("ownerAccount=$ownerAccount,")
        append("restorableUntil=$restorableUntil,")
        append("revocationConfiguration=$revocationConfiguration,")
        append("serial=$serial,")
        append("status=$status,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (certificateAuthorityConfiguration?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (keyStorageSecurityStandard?.hashCode() ?: 0)
        result = 31 * result + (lastStateChangeAt?.hashCode() ?: 0)
        result = 31 * result + (notAfter?.hashCode() ?: 0)
        result = 31 * result + (notBefore?.hashCode() ?: 0)
        result = 31 * result + (ownerAccount?.hashCode() ?: 0)
        result = 31 * result + (restorableUntil?.hashCode() ?: 0)
        result = 31 * result + (revocationConfiguration?.hashCode() ?: 0)
        result = 31 * result + (serial?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CertificateAuthority

        if (arn != other.arn) return false
        if (certificateAuthorityConfiguration != other.certificateAuthorityConfiguration) return false
        if (createdAt != other.createdAt) return false
        if (failureReason != other.failureReason) return false
        if (keyStorageSecurityStandard != other.keyStorageSecurityStandard) return false
        if (lastStateChangeAt != other.lastStateChangeAt) return false
        if (notAfter != other.notAfter) return false
        if (notBefore != other.notBefore) return false
        if (ownerAccount != other.ownerAccount) return false
        if (restorableUntil != other.restorableUntil) return false
        if (revocationConfiguration != other.revocationConfiguration) return false
        if (serial != other.serial) return false
        if (status != other.status) return false
        if (type != other.type) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.acmpca.model.CertificateAuthority = Builder(this).apply(block).build()

    class Builder {
        /**
         * Amazon Resource Name (ARN) for your private certificate authority (CA). The format is
         * 12345678-1234-1234-1234-123456789012
         * .
         */
        var arn: kotlin.String? = null
        /**
         * Your private CA configuration.
         */
        var certificateAuthorityConfiguration: aws.sdk.kotlin.services.acmpca.model.CertificateAuthorityConfiguration? = null
        /**
         * Date and time at which your private CA was created.
         */
        var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Reason the request to create your private CA failed.
         */
        var failureReason: aws.sdk.kotlin.services.acmpca.model.FailureReason? = null
        /**
         * Defines a cryptographic key management compliance standard used for handling CA keys.
         * Default: FIPS_140_2_LEVEL_3_OR_HIGHER
         * Note: AWS Region ap-northeast-3 supports only FIPS_140_2_LEVEL_2_OR_HIGHER. You must
         * explicitly specify this parameter and value when creating a CA in that Region.
         * Specifying a different value (or no value) results in an
         * InvalidArgsException with the message "A certificate authority cannot
         * be created in this region with the specified security standard."
         */
        var keyStorageSecurityStandard: aws.sdk.kotlin.services.acmpca.model.KeyStorageSecurityStandard? = null
        /**
         * Date and time at which your private CA was last updated.
         */
        var lastStateChangeAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Date and time after which your private CA certificate is not valid.
         */
        var notAfter: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Date and time before which your private CA certificate is not valid.
         */
        var notBefore: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The AWS account ID that owns the certificate authority.
         */
        var ownerAccount: kotlin.String? = null
        /**
         * The period during which a deleted CA can be restored. For more information, see the
         * PermanentDeletionTimeInDays parameter of the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeleteCertificateAuthorityRequest.html">DeleteCertificateAuthorityRequest action.
         */
        var restorableUntil: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Information about the Online Certificate Status Protocol (OCSP) configuration or
         * certificate revocation list (CRL) created and maintained by your private CA.
         */
        var revocationConfiguration: aws.sdk.kotlin.services.acmpca.model.RevocationConfiguration? = null
        /**
         * Serial number of your private CA.
         */
        var serial: kotlin.String? = null
        /**
         * Status of your private CA.
         */
        var status: aws.sdk.kotlin.services.acmpca.model.CertificateAuthorityStatus? = null
        /**
         * Type of your private CA.
         */
        var type: aws.sdk.kotlin.services.acmpca.model.CertificateAuthorityType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.acmpca.model.CertificateAuthority) : this() {
            this.arn = x.arn
            this.certificateAuthorityConfiguration = x.certificateAuthorityConfiguration
            this.createdAt = x.createdAt
            this.failureReason = x.failureReason
            this.keyStorageSecurityStandard = x.keyStorageSecurityStandard
            this.lastStateChangeAt = x.lastStateChangeAt
            this.notAfter = x.notAfter
            this.notBefore = x.notBefore
            this.ownerAccount = x.ownerAccount
            this.restorableUntil = x.restorableUntil
            this.revocationConfiguration = x.revocationConfiguration
            this.serial = x.serial
            this.status = x.status
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.acmpca.model.CertificateAuthority = CertificateAuthority(this)

        /**
         * construct an [aws.sdk.kotlin.services.acmpca.model.CertificateAuthorityConfiguration] inside the given [block]
         */
        fun certificateAuthorityConfiguration(block: aws.sdk.kotlin.services.acmpca.model.CertificateAuthorityConfiguration.Builder.() -> kotlin.Unit) {
            this.certificateAuthorityConfiguration = aws.sdk.kotlin.services.acmpca.model.CertificateAuthorityConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.acmpca.model.RevocationConfiguration] inside the given [block]
         */
        fun revocationConfiguration(block: aws.sdk.kotlin.services.acmpca.model.RevocationConfiguration.Builder.() -> kotlin.Unit) {
            this.revocationConfiguration = aws.sdk.kotlin.services.acmpca.model.RevocationConfiguration.invoke(block)
        }
    }
}
