// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model



/**
 * Contains information about the certificate subject. The Subject field in
 * the certificate identifies the entity that owns or controls the public key in the
 * certificate. The entity can be a user, computer, device, or service. The Subject
 * must contain an X.500 distinguished name (DN). A DN is a sequence of relative
 * distinguished names (RDNs). The RDNs are separated by commas in the certificate.
 */
class Asn1Subject private constructor(builder: Builder) {
    /**
     * For CA and end-entity certificates in a private PKI, the common name (CN) can be any
     * string within the length limit.
     * Note: In publicly trusted certificates, the common name must be a fully qualified
     * domain name (FQDN) associated with the certificate subject.
     */
    val commonName: kotlin.String? = builder.commonName
    /**
     * Two-digit code that specifies the country in which the certificate subject
     * located.
     */
    val country: kotlin.String? = builder.country
    /**
     * Disambiguating information for the certificate subject.
     */
    val distinguishedNameQualifier: kotlin.String? = builder.distinguishedNameQualifier
    /**
     * Typically a qualifier appended to the name of an individual. Examples include Jr. for
     * junior, Sr. for senior, and III for third.
     */
    val generationQualifier: kotlin.String? = builder.generationQualifier
    /**
     * First name.
     */
    val givenName: kotlin.String? = builder.givenName
    /**
     * Concatenation that typically contains the first letter of the GivenName, the first letter of the middle name if one exists, and the
     * first letter of the Surname.
     */
    val initials: kotlin.String? = builder.initials
    /**
     * The locality (such as a city or town) in which the certificate subject is
     * located.
     */
    val locality: kotlin.String? = builder.locality
    /**
     * Legal name of the organization with which the certificate subject is affiliated.
     */
    val organization: kotlin.String? = builder.organization
    /**
     * A subdivision or unit of the organization (such as sales or finance) with which the
     * certificate subject is affiliated.
     */
    val organizationalUnit: kotlin.String? = builder.organizationalUnit
    /**
     * Typically a shortened version of a longer GivenName.
     * For example, Jonathan is often shortened to John. Elizabeth is often shortened to Beth,
     * Liz, or Eliza.
     */
    val pseudonym: kotlin.String? = builder.pseudonym
    /**
     * The certificate serial number.
     */
    val serialNumber: kotlin.String? = builder.serialNumber
    /**
     * State in which the subject of the certificate is located.
     */
    val state: kotlin.String? = builder.state
    /**
     * Family name. In the US and the UK, for example, the surname of an individual is
     * ordered last. In Asian cultures the surname is typically ordered first.
     */
    val surname: kotlin.String? = builder.surname
    /**
     * A title such as Mr. or Ms., which is pre-pended to the name to refer formally to the
     * certificate subject.
     */
    val title: kotlin.String? = builder.title

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.acmpca.model.Asn1Subject = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Asn1Subject(")
        append("commonName=$commonName,")
        append("country=$country,")
        append("distinguishedNameQualifier=$distinguishedNameQualifier,")
        append("generationQualifier=$generationQualifier,")
        append("givenName=$givenName,")
        append("initials=$initials,")
        append("locality=$locality,")
        append("organization=$organization,")
        append("organizationalUnit=$organizationalUnit,")
        append("pseudonym=$pseudonym,")
        append("serialNumber=$serialNumber,")
        append("state=$state,")
        append("surname=$surname,")
        append("title=$title)")
    }

    override fun hashCode(): kotlin.Int {
        var result = commonName?.hashCode() ?: 0
        result = 31 * result + (country?.hashCode() ?: 0)
        result = 31 * result + (distinguishedNameQualifier?.hashCode() ?: 0)
        result = 31 * result + (generationQualifier?.hashCode() ?: 0)
        result = 31 * result + (givenName?.hashCode() ?: 0)
        result = 31 * result + (initials?.hashCode() ?: 0)
        result = 31 * result + (locality?.hashCode() ?: 0)
        result = 31 * result + (organization?.hashCode() ?: 0)
        result = 31 * result + (organizationalUnit?.hashCode() ?: 0)
        result = 31 * result + (pseudonym?.hashCode() ?: 0)
        result = 31 * result + (serialNumber?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (surname?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Asn1Subject

        if (commonName != other.commonName) return false
        if (country != other.country) return false
        if (distinguishedNameQualifier != other.distinguishedNameQualifier) return false
        if (generationQualifier != other.generationQualifier) return false
        if (givenName != other.givenName) return false
        if (initials != other.initials) return false
        if (locality != other.locality) return false
        if (organization != other.organization) return false
        if (organizationalUnit != other.organizationalUnit) return false
        if (pseudonym != other.pseudonym) return false
        if (serialNumber != other.serialNumber) return false
        if (state != other.state) return false
        if (surname != other.surname) return false
        if (title != other.title) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.acmpca.model.Asn1Subject = Builder(this).apply(block).build()

    class Builder {
        /**
         * For CA and end-entity certificates in a private PKI, the common name (CN) can be any
         * string within the length limit.
         * Note: In publicly trusted certificates, the common name must be a fully qualified
         * domain name (FQDN) associated with the certificate subject.
         */
        var commonName: kotlin.String? = null
        /**
         * Two-digit code that specifies the country in which the certificate subject
         * located.
         */
        var country: kotlin.String? = null
        /**
         * Disambiguating information for the certificate subject.
         */
        var distinguishedNameQualifier: kotlin.String? = null
        /**
         * Typically a qualifier appended to the name of an individual. Examples include Jr. for
         * junior, Sr. for senior, and III for third.
         */
        var generationQualifier: kotlin.String? = null
        /**
         * First name.
         */
        var givenName: kotlin.String? = null
        /**
         * Concatenation that typically contains the first letter of the GivenName, the first letter of the middle name if one exists, and the
         * first letter of the Surname.
         */
        var initials: kotlin.String? = null
        /**
         * The locality (such as a city or town) in which the certificate subject is
         * located.
         */
        var locality: kotlin.String? = null
        /**
         * Legal name of the organization with which the certificate subject is affiliated.
         */
        var organization: kotlin.String? = null
        /**
         * A subdivision or unit of the organization (such as sales or finance) with which the
         * certificate subject is affiliated.
         */
        var organizationalUnit: kotlin.String? = null
        /**
         * Typically a shortened version of a longer GivenName.
         * For example, Jonathan is often shortened to John. Elizabeth is often shortened to Beth,
         * Liz, or Eliza.
         */
        var pseudonym: kotlin.String? = null
        /**
         * The certificate serial number.
         */
        var serialNumber: kotlin.String? = null
        /**
         * State in which the subject of the certificate is located.
         */
        var state: kotlin.String? = null
        /**
         * Family name. In the US and the UK, for example, the surname of an individual is
         * ordered last. In Asian cultures the surname is typically ordered first.
         */
        var surname: kotlin.String? = null
        /**
         * A title such as Mr. or Ms., which is pre-pended to the name to refer formally to the
         * certificate subject.
         */
        var title: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.acmpca.model.Asn1Subject) : this() {
            this.commonName = x.commonName
            this.country = x.country
            this.distinguishedNameQualifier = x.distinguishedNameQualifier
            this.generationQualifier = x.generationQualifier
            this.givenName = x.givenName
            this.initials = x.initials
            this.locality = x.locality
            this.organization = x.organization
            this.organizationalUnit = x.organizationalUnit
            this.pseudonym = x.pseudonym
            this.serialNumber = x.serialNumber
            this.state = x.state
            this.surname = x.surname
            this.title = x.title
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.acmpca.model.Asn1Subject = Asn1Subject(this)
    }
}
