// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model



class UpdateCertificateAuthorityRequest private constructor(builder: BuilderImpl) {
    /**
     * Amazon Resource Name (ARN) of the private CA that issued the certificate to be
     * revoked. This must be of the form:
     * arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
     */
    val certificateAuthorityArn: String? = builder.certificateAuthorityArn
    /**
     * Contains information to enable Online Certificate Status Protocol (OCSP) support,
     * to enable a certificate revocation list (CRL), to enable both, or to enable neither. If
     * this parameter is not supplied, existing capibilites remain unchanged. For more
     * information, see the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_OcspConfiguration.html">OcspConfiguration and <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CrlConfiguration.html">CrlConfiguration types.
     */
    val revocationConfiguration: RevocationConfiguration? = builder.revocationConfiguration
    /**
     * Status of your private CA.
     */
    val status: CertificateAuthorityStatus? = builder.status

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UpdateCertificateAuthorityRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateCertificateAuthorityRequest(")
        append("certificateAuthorityArn=$certificateAuthorityArn,")
        append("revocationConfiguration=$revocationConfiguration,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateAuthorityArn?.hashCode() ?: 0
        result = 31 * result + (revocationConfiguration?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateCertificateAuthorityRequest

        if (certificateAuthorityArn != other.certificateAuthorityArn) return false
        if (revocationConfiguration != other.revocationConfiguration) return false
        if (status != other.status) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UpdateCertificateAuthorityRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UpdateCertificateAuthorityRequest
        /**
         * Amazon Resource Name (ARN) of the private CA that issued the certificate to be
         * revoked. This must be of the form:
         * arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
         */
        fun certificateAuthorityArn(certificateAuthorityArn: String): FluentBuilder
        /**
         * Contains information to enable Online Certificate Status Protocol (OCSP) support,
         * to enable a certificate revocation list (CRL), to enable both, or to enable neither. If
         * this parameter is not supplied, existing capibilites remain unchanged. For more
         * information, see the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_OcspConfiguration.html">OcspConfiguration and <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CrlConfiguration.html">CrlConfiguration types.
         */
        fun revocationConfiguration(revocationConfiguration: RevocationConfiguration): FluentBuilder
        /**
         * Status of your private CA.
         */
        fun status(status: CertificateAuthorityStatus): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Amazon Resource Name (ARN) of the private CA that issued the certificate to be
         * revoked. This must be of the form:
         * arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
         */
        var certificateAuthorityArn: String?
        /**
         * Contains information to enable Online Certificate Status Protocol (OCSP) support,
         * to enable a certificate revocation list (CRL), to enable both, or to enable neither. If
         * this parameter is not supplied, existing capibilites remain unchanged. For more
         * information, see the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_OcspConfiguration.html">OcspConfiguration and <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CrlConfiguration.html">CrlConfiguration types.
         */
        var revocationConfiguration: RevocationConfiguration?
        /**
         * Status of your private CA.
         */
        var status: CertificateAuthorityStatus?

        fun build(): UpdateCertificateAuthorityRequest
        /**
         * construct an [aws.sdk.kotlin.services.acmpca.model.RevocationConfiguration] inside the given [block]
         */
        fun revocationConfiguration(block: RevocationConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.revocationConfiguration = RevocationConfiguration.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var certificateAuthorityArn: String? = null
        override var revocationConfiguration: RevocationConfiguration? = null
        override var status: CertificateAuthorityStatus? = null

        constructor(x: UpdateCertificateAuthorityRequest) : this() {
            this.certificateAuthorityArn = x.certificateAuthorityArn
            this.revocationConfiguration = x.revocationConfiguration
            this.status = x.status
        }

        override fun build(): UpdateCertificateAuthorityRequest = UpdateCertificateAuthorityRequest(this)
        override fun certificateAuthorityArn(certificateAuthorityArn: String): FluentBuilder = apply { this.certificateAuthorityArn = certificateAuthorityArn }
        override fun revocationConfiguration(revocationConfiguration: RevocationConfiguration): FluentBuilder = apply { this.revocationConfiguration = revocationConfiguration }
        override fun status(status: CertificateAuthorityStatus): FluentBuilder = apply { this.status = status }
    }
}
