// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.acmpca.model



class PutPolicyRequest private constructor(builder: BuilderImpl) {
    /**
     * The path and file name of a JSON-formatted IAM policy to attach to the specified
     * private CA resource. If this policy does not contain all required statements or if it
     * includes any statement that is not allowed, the PutPolicy action returns an
     * InvalidPolicyException. For information about IAM policy and
     * statement structure, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json">Overview of JSON Policies.
     */
    val policy: String? = builder.policy
    /**
     * The Amazon Resource Number (ARN) of the private CA to associate with the policy. The
     * ARN of the CA can be found by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities action.
     */
    val resourceArn: String? = builder.resourceArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PutPolicyRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PutPolicyRequest(")
        append("policy=$policy,")
        append("resourceArn=$resourceArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = policy?.hashCode() ?: 0
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PutPolicyRequest

        if (policy != other.policy) return false
        if (resourceArn != other.resourceArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PutPolicyRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PutPolicyRequest
        /**
         * The path and file name of a JSON-formatted IAM policy to attach to the specified
         * private CA resource. If this policy does not contain all required statements or if it
         * includes any statement that is not allowed, the PutPolicy action returns an
         * InvalidPolicyException. For information about IAM policy and
         * statement structure, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json">Overview of JSON Policies.
         */
        fun policy(policy: String): FluentBuilder
        /**
         * The Amazon Resource Number (ARN) of the private CA to associate with the policy. The
         * ARN of the CA can be found by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities action.
         */
        fun resourceArn(resourceArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The path and file name of a JSON-formatted IAM policy to attach to the specified
         * private CA resource. If this policy does not contain all required statements or if it
         * includes any statement that is not allowed, the PutPolicy action returns an
         * InvalidPolicyException. For information about IAM policy and
         * statement structure, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json">Overview of JSON Policies.
         */
        var policy: String?
        /**
         * The Amazon Resource Number (ARN) of the private CA to associate with the policy. The
         * ARN of the CA can be found by calling the <a href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html">ListCertificateAuthorities action.
         */
        var resourceArn: String?

        fun build(): PutPolicyRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var policy: String? = null
        override var resourceArn: String? = null

        constructor(x: PutPolicyRequest) : this() {
            this.policy = x.policy
            this.resourceArn = x.resourceArn
        }

        override fun build(): PutPolicyRequest = PutPolicyRequest(this)
        override fun policy(policy: String): FluentBuilder = apply { this.policy = policy }
        override fun resourceArn(resourceArn: String): FluentBuilder = apply { this.resourceArn = resourceArn }
    }
}
